/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.hibernate.cache.naturalid;

import org.hibernate.cache.CacheException;
import org.hibernate.cache.spi.NaturalIdRegion;
import org.hibernate.cache.spi.access.NaturalIdRegionAccessStrategy;
import org.hibernate.cache.spi.access.SoftLock;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.persister.entity.EntityPersister;
import org.infinispan.hibernate.cache.access.AccessDelegate;
import org.infinispan.hibernate.cache.naturalid.NaturalIdRegionImpl;

class ReadOnlyAccess
implements NaturalIdRegionAccessStrategy {
    protected final NaturalIdRegionImpl region;
    protected final AccessDelegate delegate;

    ReadOnlyAccess(NaturalIdRegionImpl region, AccessDelegate delegate) {
        this.region = region;
        this.delegate = delegate;
    }

    public boolean insert(SessionImplementor session, Object key, Object value) throws CacheException {
        return this.delegate.insert(session, key, value, null);
    }

    public boolean update(SessionImplementor session, Object key, Object value) throws CacheException {
        throw new UnsupportedOperationException("Illegal attempt to edit read only item");
    }

    public NaturalIdRegion getRegion() {
        return this.region;
    }

    public void evict(Object key) throws CacheException {
        this.delegate.evict(key);
    }

    public void evictAll() throws CacheException {
        this.delegate.evictAll();
    }

    public Object get(SessionImplementor session, Object key, long txTimestamp) throws CacheException {
        return this.delegate.get(session, key, txTimestamp);
    }

    public boolean putFromLoad(SessionImplementor session, Object key, Object value, long txTimestamp, Object version) throws CacheException {
        return this.delegate.putFromLoad(session, key, value, txTimestamp, version);
    }

    public boolean putFromLoad(SessionImplementor session, Object key, Object value, long txTimestamp, Object version, boolean minimalPutOverride) throws CacheException {
        return this.delegate.putFromLoad(session, key, value, txTimestamp, version, minimalPutOverride);
    }

    public void remove(SessionImplementor session, Object key) throws CacheException {
        this.delegate.remove(session, key);
    }

    public void removeAll() throws CacheException {
        this.delegate.removeAll();
    }

    public SoftLock lockItem(SessionImplementor session, Object key, Object version) throws CacheException {
        return null;
    }

    public SoftLock lockRegion() throws CacheException {
        return null;
    }

    public void unlockItem(SessionImplementor session, Object key, SoftLock lock) throws CacheException {
        this.delegate.unlockItem(session, key);
    }

    public void unlockRegion(SoftLock lock) throws CacheException {
    }

    public boolean afterInsert(SessionImplementor session, Object key, Object value) throws CacheException {
        return this.delegate.afterInsert(session, key, value, null);
    }

    public boolean afterUpdate(SessionImplementor session, Object key, Object value, SoftLock lock) throws CacheException {
        throw new UnsupportedOperationException("Illegal attempt to edit read only item");
    }

    public Object generateCacheKey(Object[] naturalIdValues, EntityPersister persister, SessionImplementor session) {
        return this.region.getCacheKeysFactory().createNaturalIdKey(naturalIdValues, persister, session);
    }

    public Object[] getNaturalIdValues(Object cacheKey) {
        return this.region.getCacheKeysFactory().getNaturalIdValues(cacheKey);
    }
}

