/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.work.impl;

import java.lang.invoke.MethodHandles;
import java.util.concurrent.CompletableFuture;
import org.hibernate.search.engine.backend.work.execution.DocumentCommitStrategy;
import org.hibernate.search.engine.backend.work.execution.DocumentRefreshStrategy;
import org.hibernate.search.mapper.pojo.logging.impl.Log;
import org.hibernate.search.mapper.pojo.work.IndexingPlanSynchronizationStrategy;
import org.hibernate.search.mapper.pojo.work.IndexingPlanSynchronizationStrategyConfigurationContext;
import org.hibernate.search.mapper.pojo.work.SearchIndexingPlanExecutionReport;
import org.hibernate.search.util.common.annotation.Incubating;
import org.hibernate.search.util.common.impl.Futures;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

@Incubating
public final class ReadSyncIndexingPlanSynchronizationStrategy
implements IndexingPlanSynchronizationStrategy {
    public static final IndexingPlanSynchronizationStrategy INSTANCE = new ReadSyncIndexingPlanSynchronizationStrategy();
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());

    private ReadSyncIndexingPlanSynchronizationStrategy() {
    }

    public String toString() {
        return IndexingPlanSynchronizationStrategy.class.getSimpleName() + ".readSync()";
    }

    @Override
    public void apply(IndexingPlanSynchronizationStrategyConfigurationContext context) {
        context.documentCommitStrategy(DocumentCommitStrategy.NONE);
        context.documentRefreshStrategy(DocumentRefreshStrategy.FORCE);
        context.indexingFutureHandler(future -> {
            SearchIndexingPlanExecutionReport report = (SearchIndexingPlanExecutionReport)Futures.unwrappedExceptionJoin((CompletableFuture)future);
            report.throwable().ifPresent(t -> {
                throw log.indexingFailure(t.getMessage(), report.failingEntities(), (Throwable)t);
            });
        });
    }
}

