/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.tenancy.spi;

import java.lang.invoke.MethodHandles;
import java.util.Objects;
import org.hibernate.search.mapper.pojo.logging.impl.Log;
import org.hibernate.search.mapper.pojo.tenancy.TenantIdentifierConverter;
import org.hibernate.search.util.common.annotation.Incubating;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

@Incubating
public class StringTenantIdentifierConverter
implements TenantIdentifierConverter {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    public static final StringTenantIdentifierConverter INSTANCE = new StringTenantIdentifierConverter();
    public static final String NAME = "string-tenant-identifier-converter";

    @Override
    public String toStringValue(Object tenantId) {
        if (tenantId == null) {
            return null;
        }
        if (!(tenantId instanceof CharSequence)) {
            throw log.nonStringTenantId(tenantId);
        }
        return Objects.toString(tenantId);
    }

    @Override
    public Object fromStringValue(String tenantId) {
        return tenantId;
    }
}

