/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.model.path.impl;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public final class PojoPathOrdinals {
    private final Map<String, Integer> ordinalByPath = new HashMap<String, Integer>();
    private final List<String> pathByOrdinal = new ArrayList<String>();

    public String toString() {
        return "PojoPathOrdinals{ordinalByPath=" + String.valueOf(this.ordinalByPath) + "}";
    }

    public Integer toOrdinal(String path) {
        return this.ordinalByPath.get(path);
    }

    public String toPath(int ordinal) {
        return ordinal < this.pathByOrdinal.size() ? this.pathByOrdinal.get(ordinal) : null;
    }

    public BitSet toPathSelection(Collection<String> paths) {
        if (paths.isEmpty()) {
            return null;
        }
        BitSet bitSet = null;
        for (String path : paths) {
            Integer ordinal = this.toOrdinal(path);
            if (ordinal == null) continue;
            if (bitSet == null) {
                bitSet = new BitSet();
            }
            bitSet.set(ordinal);
        }
        return bitSet;
    }

    public Set<String> toPathSet(BitSet pathSelection) {
        if (pathSelection == null) {
            return Collections.emptySet();
        }
        return pathSelection.stream().mapToObj(this::toPath).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    public int toExistingOrNewOrdinal(String path) {
        Integer ordinal = this.ordinalByPath.get(path);
        if (ordinal != null) {
            return ordinal;
        }
        this.pathByOrdinal.add(path);
        ordinal = this.pathByOrdinal.size() - 1;
        this.ordinalByPath.put(path, ordinal);
        return ordinal;
    }
}

