/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.automaticindexing.building.impl;

import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.hibernate.search.mapper.pojo.automaticindexing.building.impl.AbstractPojoImplicitReindexingResolverTypeNodeBuilder;
import org.hibernate.search.mapper.pojo.automaticindexing.building.impl.PojoImplicitReindexingResolverBuildingHelper;
import org.hibernate.search.mapper.pojo.automaticindexing.building.impl.PojoImplicitReindexingResolverOriginalTypeNodeBuilder;
import org.hibernate.search.mapper.pojo.automaticindexing.building.impl.PojoImplicitReindexingResolverPropertyNodeBuilder;
import org.hibernate.search.mapper.pojo.automaticindexing.building.impl.PojoImplicitReindexingResolverValueNodeBuilderDelegate;
import org.hibernate.search.mapper.pojo.automaticindexing.impl.PojoImplicitReindexingResolver;
import org.hibernate.search.mapper.pojo.automaticindexing.impl.PojoImplicitReindexingResolverImpl;
import org.hibernate.search.mapper.pojo.automaticindexing.impl.PojoImplicitReindexingResolverNode;
import org.hibernate.search.mapper.pojo.model.path.PojoModelPathPropertyNode;
import org.hibernate.search.mapper.pojo.model.path.PojoModelPathValueNode;
import org.hibernate.search.mapper.pojo.model.path.impl.BoundPojoModelPath;
import org.hibernate.search.mapper.pojo.model.path.impl.BoundPojoModelPathValueNode;
import org.hibernate.search.mapper.pojo.model.path.impl.PojoRuntimePathsBuildingHelper;
import org.hibernate.search.mapper.pojo.model.path.spi.PojoModelPathWalker;
import org.hibernate.search.mapper.pojo.model.path.spi.PojoPathFilter;
import org.hibernate.search.mapper.pojo.model.spi.PojoRawTypeModel;
import org.hibernate.search.util.common.AssertionFailure;

class PojoImplicitReindexingResolverBuilder<T> {
    private final PojoRawTypeModel<T> rawTypeModel;
    private final PojoImplicitReindexingResolverBuildingHelper buildingHelper;
    private final Set<PojoModelPathValueNode> dirtyPathsTriggeringSelfReindexing = new LinkedHashSet<PojoModelPathValueNode>();
    private final Map<PojoModelPathValueNode, Map<PojoRawTypeModel<?>, PojoModelPathValueNode>> containingAssociationPaths = new LinkedHashMap();
    private final PojoImplicitReindexingResolverOriginalTypeNodeBuilder<T> containingEntitiesResolverRootBuilder;
    private boolean frozen = false;

    static Walker walker() {
        return Walker.INSTANCE;
    }

    PojoImplicitReindexingResolverBuilder(PojoRawTypeModel<T> rawTypeModel, PojoImplicitReindexingResolverBuildingHelper buildingHelper) {
        this.rawTypeModel = rawTypeModel;
        this.buildingHelper = buildingHelper;
        this.containingEntitiesResolverRootBuilder = new PojoImplicitReindexingResolverOriginalTypeNodeBuilder<T>(BoundPojoModelPath.root(rawTypeModel), buildingHelper);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + String.valueOf(this.rawTypeModel) + "]";
    }

    void closeOnFailure() {
        this.containingEntitiesResolverRootBuilder.closeOnFailure();
    }

    void addDirtyPathTriggeringSelfReindexing(BoundPojoModelPathValueNode<?, ?, ?> dirtyPathFromEntityType) {
        this.checkNotFrozen();
        this.dirtyPathsTriggeringSelfReindexing.add(dirtyPathFromEntityType.toUnboundPath());
    }

    void addContainingAssociationPath(PojoModelPathValueNode pathFromContainedSide, PojoRawTypeModel<?> containingType, PojoModelPathValueNode pathFromContainingSide) {
        this.checkNotFrozen();
        this.containingAssociationPaths.computeIfAbsent(pathFromContainedSide, ignored -> new LinkedHashMap()).put(containingType, pathFromContainingSide);
    }

    PojoImplicitReindexingResolverOriginalTypeNodeBuilder<T> containingEntitiesResolverRoot() {
        return this.containingEntitiesResolverRootBuilder;
    }

    final Optional<PojoImplicitReindexingResolver<T>> build() {
        this.freeze();
        PojoRuntimePathsBuildingHelper pathsBuildingHelper = this.buildingHelper.runtimePathsBuildingHelper(this.rawTypeModel);
        Set<PojoModelPathValueNode> immutableDirtyPathsAcceptedByFilter = this.dirtyPathsTriggeringSelfReindexing;
        Optional<PojoImplicitReindexingResolverNode<PojoImplicitReindexingResolverNode>> containingEntitiesResolverRootOptional = this.containingEntitiesResolverRootBuilder.build(pathsBuildingHelper, null);
        if (immutableDirtyPathsAcceptedByFilter.isEmpty() && !containingEntitiesResolverRootOptional.isPresent() && this.containingAssociationPaths.isEmpty()) {
            return Optional.empty();
        }
        PojoPathFilter dirtySelfFilter = pathsBuildingHelper.createFilter(immutableDirtyPathsAcceptedByFilter);
        PojoImplicitReindexingResolverNode containingEntitiesResolverRoot = containingEntitiesResolverRootOptional.orElseGet(PojoImplicitReindexingResolverNode::noOp);
        HashSet<PojoModelPathValueNode> dirtySelfOrContainingPaths = new HashSet<PojoModelPathValueNode>(immutableDirtyPathsAcceptedByFilter);
        dirtySelfOrContainingPaths.addAll(this.containingEntitiesResolverRootBuilder.getDirtyPathsTriggeringReindexingIncludingNestedNodes());
        PojoPathFilter dirtySelfOrContainingFilter = pathsBuildingHelper.createFilter(dirtySelfOrContainingPaths);
        return Optional.of(new PojoImplicitReindexingResolverImpl(dirtySelfFilter, dirtySelfOrContainingFilter, containingEntitiesResolverRoot, this.buildingHelper.createAssociationInverseSideResolver(this.rawTypeModel, this.containingAssociationPaths)));
    }

    private void freeze() {
        if (!this.frozen) {
            this.frozen = true;
            this.containingEntitiesResolverRootBuilder.freeze();
        }
    }

    private void checkNotFrozen() {
        if (this.frozen) {
            throw new AssertionFailure("A mutating method was called on " + String.valueOf(this) + " after it was frozen.");
        }
    }

    static class Walker
    implements PojoModelPathWalker<Void, AbstractPojoImplicitReindexingResolverTypeNodeBuilder<?, ?>, PojoImplicitReindexingResolverPropertyNodeBuilder<?, ?>, PojoImplicitReindexingResolverValueNodeBuilderDelegate<?>> {
        public static final Walker INSTANCE = new Walker();

        Walker() {
        }

        @Override
        public PojoImplicitReindexingResolverPropertyNodeBuilder<?, ?> property(Void context, AbstractPojoImplicitReindexingResolverTypeNodeBuilder<?, ?> typeNode, PojoModelPathPropertyNode pathNode) {
            return typeNode.property(pathNode.propertyName());
        }

        @Override
        public PojoImplicitReindexingResolverValueNodeBuilderDelegate<?> value(Void context, PojoImplicitReindexingResolverPropertyNodeBuilder<?, ?> propertyNode, PojoModelPathValueNode pathNode) {
            return propertyNode.value(pathNode.extractorPath());
        }

        @Override
        public AbstractPojoImplicitReindexingResolverTypeNodeBuilder<?, ?> type(Void context, PojoImplicitReindexingResolverValueNodeBuilderDelegate<?> valueNode) {
            return valueNode.type();
        }
    }
}

