/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.engine.execution;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Parameter;
import java.util.List;
import java.util.Optional;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.platform.commons.util.AnnotationUtils;
import org.junit.platform.commons.util.Preconditions;
import org.junit.platform.commons.util.ReflectionUtils;
import org.junit.platform.commons.util.ToStringBuilder;

class DefaultParameterContext
implements ParameterContext {
    private final Parameter parameter;
    private final int index;
    private final Optional<Object> target;

    DefaultParameterContext(Parameter parameter, int index, Optional<Object> target) {
        Preconditions.condition(index >= 0, "index must be greater than or equal to zero");
        this.parameter = Preconditions.notNull(parameter, "parameter must not be null");
        this.index = index;
        this.target = Preconditions.notNull(target, "target must not be null");
    }

    public Parameter getParameter() {
        return this.parameter;
    }

    public int getIndex() {
        return this.index;
    }

    public Optional<Object> getTarget() {
        return this.target;
    }

    public boolean isAnnotated(Class<? extends Annotation> annotationType) {
        return AnnotationUtils.isAnnotated(this.getEffectiveAnnotatedParameter(), annotationType);
    }

    public <A extends Annotation> Optional<A> findAnnotation(Class<A> annotationType) {
        return AnnotationUtils.findAnnotation(this.getEffectiveAnnotatedParameter(), annotationType);
    }

    public <A extends Annotation> List<A> findRepeatableAnnotations(Class<A> annotationType) {
        return AnnotationUtils.findRepeatableAnnotations(this.getEffectiveAnnotatedParameter(), annotationType);
    }

    private AnnotatedElement getEffectiveAnnotatedParameter() {
        Executable executable = this.getDeclaringExecutable();
        if (executable instanceof Constructor && ReflectionUtils.isInnerClass(executable.getDeclaringClass()) && executable.getParameterAnnotations().length == executable.getParameterCount() - 1) {
            Preconditions.condition(this.index != 0, "A ParameterContext should never be created for parameter index 0 in an inner class constructor");
            return executable.getParameters()[this.index - 1];
        }
        return this.parameter;
    }

    public String toString() {
        return new ToStringBuilder(this).append("parameter", this.parameter).append("index", this.index).append("target", this.target).toString();
    }
}

