/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.scim.security;

import java.util.Collection;
import org.cloudfoundry.identity.uaa.authentication.UaaPrincipal;
import org.springframework.security.access.AccessDecisionVoter;
import org.springframework.security.access.ConfigAttribute;
import org.springframework.security.core.Authentication;
import org.springframework.security.oauth2.provider.OAuth2Authentication;
import org.springframework.security.web.FilterInvocation;
import org.springframework.util.StringUtils;

public class UserVoter
implements AccessDecisionVoter<Object> {
    private String configAttribute = "user=self";

    public void setConfigAttribute(String configAttribute) {
        this.configAttribute = configAttribute;
    }

    public boolean supports(ConfigAttribute attribute) {
        return StringUtils.hasText((String)attribute.getAttribute()) && attribute.getAttribute().equalsIgnoreCase(this.configAttribute);
    }

    public boolean supports(Class<?> clazz) {
        return FilterInvocation.class.isAssignableFrom(clazz);
    }

    public int vote(Authentication authentication, Object object, Collection<ConfigAttribute> attributes) {
        if (authentication instanceof OAuth2Authentication && ((OAuth2Authentication)authentication).isClientOnly()) {
            return 0;
        }
        for (ConfigAttribute attribute : attributes) {
            String userIdInRequest;
            if (!this.supports(attribute) || !(authentication.getPrincipal() instanceof UaaPrincipal)) continue;
            String userIdInContext = ((UaaPrincipal)authentication.getPrincipal()).getId();
            return userIdInContext.equals(userIdInRequest = this.getIdInPathParam(((FilterInvocation)object).getRequestUrl())) ? 1 : -1;
        }
        return 0;
    }

    private String getIdInPathParam(String url) {
        int startIndex = url.lastIndexOf("/") + 1;
        int endIndex = url.indexOf("?") > 0 ? url.indexOf("?") : url.length();
        return url.substring(startIndex, endIndex);
    }
}

