/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.scim.event;

import java.util.List;
import org.cloudfoundry.identity.uaa.audit.event.GroupModifiedEvent;
import org.cloudfoundry.identity.uaa.audit.event.UserModifiedEvent;
import org.cloudfoundry.identity.uaa.scim.ScimGroup;
import org.cloudfoundry.identity.uaa.scim.ScimGroupMember;
import org.cloudfoundry.identity.uaa.scim.ScimUser;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;

public class ScimEventPublisher
implements ApplicationEventPublisherAware {
    private ApplicationEventPublisher publisher;

    public void setApplicationEventPublisher(ApplicationEventPublisher applicationEventPublisher) {
        this.publisher = applicationEventPublisher;
    }

    public void userCreated(ScimUser user) {
        this.publish((ApplicationEvent)UserModifiedEvent.userCreated((String)user.getId(), (String)user.getUserName()));
    }

    public void userVerified(ScimUser user) {
        this.publish((ApplicationEvent)UserModifiedEvent.userVerified((String)user.getId(), (String)user.getUserName()));
    }

    public void userModified(ScimUser user) {
        this.publish((ApplicationEvent)UserModifiedEvent.userModified((String)user.getId(), (String)user.getUserName()));
    }

    public void userDeleted(ScimUser user) {
        this.publish((ApplicationEvent)UserModifiedEvent.userDeleted((String)user.getId(), (String)user.getUserName()));
    }

    public void groupCreated(ScimGroup group) {
        this.publish((ApplicationEvent)GroupModifiedEvent.groupCreated((String)group.getId(), (String)group.getDisplayName(), (String[])ScimEventPublisher.getMembers(group)));
    }

    public void groupModified(ScimGroup group) {
        this.publish((ApplicationEvent)GroupModifiedEvent.groupModified((String)group.getId(), (String)group.getDisplayName(), (String[])ScimEventPublisher.getMembers(group)));
    }

    public void groupDeleted(ScimGroup group) {
        this.publish((ApplicationEvent)GroupModifiedEvent.groupDeleted((String)group.getId(), (String)group.getDisplayName(), (String[])ScimEventPublisher.getMembers(group)));
    }

    public static String[] getMembers(ScimGroup group) {
        List<ScimGroupMember> gm = group.getMembers();
        String[] members = new String[gm != null ? gm.size() : 0];
        for (int i = 0; i < members.length; ++i) {
            members[i] = gm.get(i).getMemberId();
        }
        return members;
    }

    public void publish(ApplicationEvent event) {
        if (this.publisher != null) {
            this.publisher.publishEvent(event);
        }
    }
}

