/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.password;

import java.util.Arrays;
import org.cloudfoundry.identity.uaa.scim.endpoints.PasswordScore;
import org.cloudfoundry.identity.uaa.scim.endpoints.PasswordScoreCalculator;
import szxcvbn.ZxcvbnHelper;

public class ZxcvbnPasswordScoreCalculator
implements PasswordScoreCalculator {
    private final Integer requiredScore;

    public ZxcvbnPasswordScoreCalculator(int requiredScore) {
        this.requiredScore = requiredScore;
    }

    @Override
    public PasswordScore computeScore(String password, String ... userData) {
        int score = ZxcvbnHelper.zxcvbn((String)password, Arrays.asList(userData)).score();
        return new PasswordScore(score, this.requiredScore);
    }
}

