/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.authorization.external;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.cloudfoundry.identity.uaa.authorization.ExternalGroupMappingAuthorizationManager;
import org.cloudfoundry.identity.uaa.ldap.extension.LdapAuthority;
import org.cloudfoundry.identity.uaa.scim.ScimGroupExternalMember;
import org.cloudfoundry.identity.uaa.scim.ScimGroupExternalMembershipManager;
import org.cloudfoundry.identity.uaa.scim.ScimGroupProvisioning;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;

public class LdapGroupMappingAuthorizationManager
implements ExternalGroupMappingAuthorizationManager {
    private ScimGroupExternalMembershipManager extMbrMgr;
    private ScimGroupProvisioning scimGroupProvisioning;
    private static final Log logger = LogFactory.getLog(LdapGroupMappingAuthorizationManager.class);

    public Set<? extends GrantedAuthority> findScopesFromAuthorities(Set<? extends GrantedAuthority> authorities) {
        HashSet<Object> result = new HashSet<Object>();
        for (GrantedAuthority grantedAuthority : authorities) {
            if (grantedAuthority instanceof LdapAuthority) {
                LdapAuthority la = (LdapAuthority)grantedAuthority;
                List<ScimGroupExternalMember> members = this.extMbrMgr.getExternalGroupMapsByExternalGroup(la.getDn());
                for (ScimGroupExternalMember member : members) {
                    SimpleGrantedAuthority mapped = new SimpleGrantedAuthority(member.getDisplayName());
                    result.add(mapped);
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug((Object)("Ldap Group Mapped[dn=" + la.getDn() + " scope:" + mapped.getAuthority()));
                }
                continue;
            }
            result.add(grantedAuthority);
        }
        return result;
    }

    public void setExternalMembershipManager(ScimGroupExternalMembershipManager externalMembershipManager) {
        this.extMbrMgr = externalMembershipManager;
    }

    public void setScimGroupProvisioning(ScimGroupProvisioning scimGroupProvisioning) {
        this.scimGroupProvisioning = scimGroupProvisioning;
    }
}

