/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.reactive.jaxb.runtime.serialisers;

import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import javax.inject.Inject;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.jboss.resteasy.reactive.common.util.StreamUtil;
import org.jboss.resteasy.reactive.server.spi.ResteasyReactiveResourceInfo;
import org.jboss.resteasy.reactive.server.spi.ServerMessageBodyReader;
import org.jboss.resteasy.reactive.server.spi.ServerRequestContext;

public class ServerJaxbMessageBodyReader
implements ServerMessageBodyReader<Object> {
    @Inject
    Unmarshaller unmarshaller;

    public Object readFrom(Class<Object> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws WebApplicationException, IOException {
        return this.doReadFrom(type, genericType, entityStream);
    }

    public Object readFrom(Class<Object> type, Type genericType, MediaType mediaType, ServerRequestContext context) throws WebApplicationException, IOException {
        return this.doReadFrom(type, genericType, context.getInputStream());
    }

    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return this.isReadable(mediaType, type);
    }

    public boolean isReadable(Class<?> type, Type genericType, ResteasyReactiveResourceInfo lazyMethod, MediaType mediaType) {
        return this.isReadable(mediaType, type);
    }

    protected boolean isReadable(MediaType mediaType, Class<?> type) {
        if (mediaType == null) {
            return false;
        }
        if (String.class.equals(type)) {
            return false;
        }
        String subtype = mediaType.getSubtype();
        boolean isCorrectMediaType = "application".equals(mediaType.getType()) || "text".equals(mediaType.getType());
        return isCorrectMediaType && "xml".equalsIgnoreCase(subtype) || subtype.endsWith("+xml") || mediaType.isWildcardSubtype() && (mediaType.isWildcardType() || isCorrectMediaType);
    }

    protected Object unmarshal(InputStream entityStream, Class<Object> type) {
        try {
            JAXBElement item = this.unmarshaller.unmarshal((Source)new StreamSource(entityStream), type);
            return item.getValue();
        }
        catch (JAXBException e) {
            throw new RuntimeException(e);
        }
    }

    private Object doReadFrom(Class<Object> type, Type genericType, InputStream entityStream) throws IOException {
        if (this.isInputStreamEmpty(entityStream)) {
            return null;
        }
        return this.unmarshal(entityStream, type);
    }

    private boolean isInputStreamEmpty(InputStream entityStream) throws IOException {
        return StreamUtil.isEmpty((InputStream)entityStream) || entityStream.available() == 0;
    }
}

