/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.platform.descriptor.loader.json.impl;

import io.quarkus.dependencies.Category;
import io.quarkus.dependencies.Extension;
import io.quarkus.platform.descriptor.QuarkusPlatformDescriptor;
import io.quarkus.platform.descriptor.ResourceInputStreamConsumer;
import io.quarkus.platform.descriptor.loader.json.ResourceLoader;
import io.quarkus.platform.descriptor.loader.json.impl.QuarkusJsonPlatformBom;
import io.quarkus.platform.tools.DefaultMessageWriter;
import io.quarkus.platform.tools.MessageWriter;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.maven.model.Dependency;

public class QuarkusJsonPlatformDescriptor
implements QuarkusPlatformDescriptor {
    private String bomGroupId;
    private String bomArtifactId;
    private String bomVersion;
    private String quarkusVersion;
    private List<Extension> extensions = Collections.emptyList();
    private List<Dependency> managedDeps = Collections.emptyList();
    private List<Category> categories = Collections.emptyList();
    private ResourceLoader resourceLoader;
    private MessageWriter log;

    public void setBom(QuarkusJsonPlatformBom bom) {
        this.bomGroupId = bom.groupId;
        this.bomArtifactId = bom.artifactId;
        this.bomVersion = bom.version;
    }

    public void setQuarkusCoreVersion(String quarkusVersion) {
        this.quarkusVersion = quarkusVersion;
    }

    public void setExtensions(List<Extension> extensions) {
        this.extensions = extensions;
    }

    void setManagedDependencies(List<Dependency> managedDeps) {
        this.managedDeps = managedDeps;
    }

    void setResourceLoader(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    void setMessageWriter(MessageWriter log) {
        this.log = log;
    }

    void setQuarkusVersion(String quarkusVersion) {
        this.quarkusVersion = quarkusVersion;
    }

    private MessageWriter getLog() {
        return this.log == null ? (this.log = new DefaultMessageWriter()) : this.log;
    }

    public String getBomGroupId() {
        return this.bomGroupId;
    }

    public String getBomArtifactId() {
        return this.bomArtifactId;
    }

    public String getBomVersion() {
        return this.bomVersion;
    }

    public String getQuarkusVersion() {
        return this.quarkusVersion;
    }

    public List<Dependency> getManagedDependencies() {
        return this.managedDeps;
    }

    public List<Extension> getExtensions() {
        return this.extensions;
    }

    public String getTemplate(String name) {
        this.getLog().debug("Loading Quarkus project template %s", new Object[]{name});
        if (this.resourceLoader == null) {
            throw new IllegalStateException("Resource loader has not been provided");
        }
        try {
            return (String)this.resourceLoader.loadResource(name, is -> {
                try (BufferedReader reader = new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8));){
                    String string = reader.lines().collect(Collectors.joining("\n"));
                    return string;
                }
            });
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to load " + name, e);
        }
    }

    public <T> T loadResource(String name, ResourceInputStreamConsumer<T> consumer) throws IOException {
        this.getLog().debug("Loading Quarkus platform resource %s", new Object[]{name});
        if (this.resourceLoader == null) {
            throw new IllegalStateException("Resource loader has not been provided");
        }
        return (T)this.resourceLoader.loadResource(name, consumer);
    }

    public List<Category> getCategories() {
        return this.categories;
    }
}

