/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.caffeine.deployment;

import io.quarkus.builder.item.BuildItem;
import io.quarkus.caffeine.runtime.graal.CacheConstructorsFeature;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.NativeImageFeatureBuildItem;
import io.quarkus.deployment.builditem.nativeimage.NativeImageSystemPropertyBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.deployment.metrics.MetricsCapabilityBuildItem;
import io.quarkus.deployment.pkg.steps.NativeOrNativeSourcesBuild;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Optional;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;

public class CaffeineProcessor {
    private static final String CACHE_LOADER_CLASS_NAME = "com.github.benmanes.caffeine.cache.CacheLoader";
    private static final String CACHE_LOADER_TO_EXCLUDE = "com.github.benmanes.caffeine.cache.BoundedLocalCache$BoundedLocalAsyncLoadingCache$AsyncLoader";
    private static final DotName CACHE_LOADER_NAME = DotName.createSimple((String)"com.github.benmanes.caffeine.cache.CacheLoader");

    @BuildStep
    void cacheLoaders(CombinedIndexBuildItem combinedIndex, BuildProducer<ReflectiveClassBuildItem> reflectiveClasses) {
        Collection implementors = combinedIndex.getIndex().getAllKnownImplementors(CACHE_LOADER_NAME);
        ArrayList<String> effectiveImplementorNames = new ArrayList<String>(implementors.size());
        for (ClassInfo info : implementors) {
            if (CACHE_LOADER_TO_EXCLUDE.equals(info.name().toString())) continue;
            effectiveImplementorNames.add(info.name().toString());
        }
        if (!effectiveImplementorNames.isEmpty()) {
            reflectiveClasses.produce((BuildItem)new ReflectiveClassBuildItem(true, false, new String[]{CACHE_LOADER_CLASS_NAME}));
            for (String name : effectiveImplementorNames) {
                reflectiveClasses.produce((BuildItem)new ReflectiveClassBuildItem(true, false, new String[]{name}));
            }
        }
    }

    @BuildStep(onlyIf={NativeOrNativeSourcesBuild.class})
    NativeImageFeatureBuildItem nativeImageFeature() {
        return new NativeImageFeatureBuildItem(CacheConstructorsFeature.class);
    }

    @BuildStep(onlyIf={NativeOrNativeSourcesBuild.class})
    NativeImageSystemPropertyBuildItem registerRecordStatsImplementationsIfMicrometerAround(Optional<MetricsCapabilityBuildItem> metricsCapability) {
        if (metricsCapability.isEmpty()) {
            return null;
        }
        if (!metricsCapability.get().metricsSupported("micrometer")) {
            return null;
        }
        return new NativeImageSystemPropertyBuildItem("io.quarkus.caffeine.graalvm.recordStats", "true");
    }
}

