/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wsat.utils;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.jaxws.wsat.Constants;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.wsat.service.Protocol;
import com.ibm.ws.wsat.service.ProtocolServiceWrapper;
import com.ibm.ws.wsat.service.WSATException;
import com.ibm.ws.wsat.service.WSATFault;
import com.ibm.ws.wsat.utils.WSATControlUtil;
import com.ibm.ws.wsat.utils.WSCoorUtil;
import com.ibm.ws.wsat.webservice.client.soap.Detail;
import com.ibm.ws.wsat.webservice.client.wsat.Notification;
import com.ibm.ws.wsat.webservice.client.wscoor.RegisterResponseType;
import com.ibm.ws.wsat.webservice.client.wscoor.RegisterType;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.ws.WebServiceContext;
import org.apache.cxf.headers.Header;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.jaxws.context.WrappedMessageContext;
import org.apache.cxf.ws.addressing.EndpointReferenceType;
import org.w3c.dom.Element;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class WSATRequestHandler {
    private static WSATRequestHandler instance = null;
    private static final TraceComponent tc = Tr.register(WSATRequestHandler.class, (String)"WSAT", null);
    static final long serialVersionUID = 6266400961892478541L;

    @Trivial
    private WSATRequestHandler() {
    }

    @Trivial
    public static WSATRequestHandler getInstance() {
        if (instance == null) {
            instance = new WSATRequestHandler();
        }
        return instance;
    }

    /*
     * WARNING - void declaration
     */
    private RegisterResponseType doRegister(Map<String, String> wsatProperties, String protocolId, EndpointReferenceType participant, String txID, String recoveryID) throws Throwable {
        String errorStr = null;
        Protocol service = WSCoorUtil.getProtocolService();
        EndpointReferenceType coordinator = null;
        if (txID == null) {
            errorStr = "txID is NULL";
        } else if (!WSATControlUtil.getInstance().checkProtocolId(protocolId)) {
            errorStr = "protocolId [" + protocolId + "] is NOT SUPPORTED";
        } else if (service == null) {
            errorStr = "Protocol service is NULL";
        } else {
            try {
                coordinator = service.registrationRegister(wsatProperties, txID, participant, recoveryID);
            }
            catch (WSATException wSATException) {
                void e;
                FFDCFilter.processException((Throwable)wSATException, (String)"com.ibm.ws.wsat.utils.WSATRequestHandler", (String)"72", (Object)this, (Object[])new Object[]{wsatProperties, protocolId, participant, txID, recoveryID});
                errorStr = WSATControlUtil.getInstance().trace((Throwable)e);
            }
        }
        if (errorStr != null) {
            throw new WSATException(errorStr);
        }
        RegisterResponseType response = new RegisterResponseType();
        response.setCoordinatorProtocolService(coordinator);
        return response;
    }

    public RegisterResponseType handleRegistrationRequest(RegisterType parameters, WebServiceContext ctx) throws Throwable {
        WrappedMessageContext wmc = (WrappedMessageContext)ctx.getMessageContext();
        List headers = CastUtils.cast((List)((List)wmc.getWrappedMessage().get((Object)Header.HEADER_LIST)));
        String protocolId = parameters.getProtocolIdentifier();
        EndpointReferenceType epr = parameters.getParticipantProtocolService();
        Map<String, String> wsatProperties = WSATControlUtil.getInstance().getPropertiesMap(headers);
        if (tc.isDebugEnabled()) {
            wsatProperties.entrySet().stream().forEach(e -> Tr.debug((TraceComponent)tc, (String)"handleRegistrationRequest", (Object[])new Object[]{(String)e.getKey() + " -> " + (String)e.getValue()}));
        }
        String txID = null;
        for (Object obj : epr.getReferenceParameters().getAny()) {
            try {
                Element name = (Element)obj;
                if (!Constants.WS_WSAT_CTX_REF.getLocalPart().equals(name.getLocalName()) || !Constants.WS_WSAT_CTX_REF.getNamespaceURI().equals(name.getNamespaceURI())) continue;
                txID = name.getFirstChild().getNodeValue();
            }
            catch (Throwable throwable) {
                FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.wsat.utils.WSATRequestHandler", (String)"105", (Object)this, (Object[])new Object[]{parameters, ctx});
            }
        }
        if (txID == null) {
            txID = wsatProperties.get(Constants.WS_WSAT_CTX_REF.getLocalPart());
        }
        String recoveryID = wsatProperties.get(Constants.WS_WSAT_REC_REF.getLocalPart());
        return this.doRegister(wsatProperties, protocolId, epr, txID, recoveryID);
    }

    public void handleFaultRequest(QName faultcode, String faultstring, String faultactor, Detail detail) throws WSATException {
        WSCoorUtil.getHandlerService().handleClientFault();
    }

    /*
     * WARNING - void declaration
     */
    public void handleParticipantPrepareRequest(Notification parameters, WebServiceContext ctx) throws WSATException {
        WrappedMessageContext wmc = (WrappedMessageContext)ctx.getMessageContext();
        ProtocolServiceWrapper wrapper = WSATControlUtil.getInstance().getService(wmc);
        try {
            wrapper.getService().participantPrepare(wrapper);
        }
        catch (WSATException wSATException) {
            void e;
            FFDCFilter.processException((Throwable)wSATException, (String)"com.ibm.ws.wsat.utils.WSATRequestHandler", (String)"129", (Object)this, (Object[])new Object[]{parameters, ctx});
            wrapper.getService().wsatFault(wrapper.getTxID(), WSATFault.getUnknownTransaction((String)e.getMessage()));
        }
    }

    /*
     * WARNING - void declaration
     */
    public void handleParticipantCommitRequest(Notification parameters, WebServiceContext ctx) throws WSATException {
        WrappedMessageContext wmc = (WrappedMessageContext)ctx.getMessageContext();
        ProtocolServiceWrapper wrapper = WSATControlUtil.getInstance().getService(wmc);
        try {
            wrapper.getService().participantCommit(wrapper);
        }
        catch (WSATException wSATException) {
            void e;
            FFDCFilter.processException((Throwable)wSATException, (String)"com.ibm.ws.wsat.utils.WSATRequestHandler", (String)"141", (Object)this, (Object[])new Object[]{parameters, ctx});
            wrapper.getService().wsatFault(wrapper.getTxID(), WSATFault.getUnknownTransaction((String)e.getMessage()));
        }
    }

    /*
     * WARNING - void declaration
     */
    public void handleParticipantRollbackRequest(Notification parameters, WebServiceContext ctx) throws WSATException {
        WrappedMessageContext wmc = (WrappedMessageContext)ctx.getMessageContext();
        ProtocolServiceWrapper wrapper = WSATControlUtil.getInstance().getService(wmc);
        try {
            wrapper.getService().participantRollback(wrapper);
        }
        catch (WSATException wSATException) {
            void e;
            FFDCFilter.processException((Throwable)wSATException, (String)"com.ibm.ws.wsat.utils.WSATRequestHandler", (String)"153", (Object)this, (Object[])new Object[]{parameters, ctx});
            wrapper.getService().wsatFault(wrapper.getTxID(), WSATFault.getUnknownTransaction((String)e.getMessage()));
        }
    }

    /*
     * WARNING - void declaration
     */
    public void handleCoordinatorPreparedRequest(Notification parameters, WebServiceContext ctx) throws WSATException {
        WrappedMessageContext wmc = (WrappedMessageContext)ctx.getMessageContext();
        ProtocolServiceWrapper wrapper = WSATControlUtil.getInstance().getService(wmc);
        try {
            wrapper.getService().coordinatorPrepared(wrapper);
        }
        catch (WSATException wSATException) {
            void e;
            FFDCFilter.processException((Throwable)wSATException, (String)"com.ibm.ws.wsat.utils.WSATRequestHandler", (String)"164", (Object)this, (Object[])new Object[]{parameters, ctx});
            wrapper.getService().wsatFault(wrapper.getTxID(), WSATFault.getUnknownTransaction((String)e.getMessage()));
        }
    }

    /*
     * WARNING - void declaration
     */
    public void handleCoordinatorCommittedRequest(Notification parameters, WebServiceContext ctx) throws WSATException {
        WrappedMessageContext wmc = (WrappedMessageContext)ctx.getMessageContext();
        ProtocolServiceWrapper wrapper = WSATControlUtil.getInstance().getService(wmc);
        try {
            wrapper.getService().coordinatorCommitted(wrapper);
        }
        catch (WSATException wSATException) {
            void e;
            FFDCFilter.processException((Throwable)wSATException, (String)"com.ibm.ws.wsat.utils.WSATRequestHandler", (String)"176", (Object)this, (Object[])new Object[]{parameters, ctx});
            wrapper.getService().wsatFault(wrapper.getTxID(), WSATFault.getUnknownTransaction((String)e.getMessage()));
        }
    }

    /*
     * WARNING - void declaration
     */
    public void handleCoordinatorReadonlyRequest(Notification parameters, WebServiceContext ctx) throws WSATException {
        WrappedMessageContext wmc = (WrappedMessageContext)ctx.getMessageContext();
        ProtocolServiceWrapper wrapper = WSATControlUtil.getInstance().getService(wmc);
        try {
            wrapper.getService().coordinatorReadOnly(wrapper);
        }
        catch (WSATException wSATException) {
            void e;
            FFDCFilter.processException((Throwable)wSATException, (String)"com.ibm.ws.wsat.utils.WSATRequestHandler", (String)"187", (Object)this, (Object[])new Object[]{parameters, ctx});
            wrapper.getService().wsatFault(wrapper.getTxID(), WSATFault.getUnknownTransaction((String)e.getMessage()));
        }
    }

    /*
     * WARNING - void declaration
     */
    public void handleCoordinatorAbortedRequest(Notification parameters, WebServiceContext ctx) throws WSATException {
        WrappedMessageContext wmc = (WrappedMessageContext)ctx.getMessageContext();
        ProtocolServiceWrapper wrapper = WSATControlUtil.getInstance().getService(wmc);
        try {
            wrapper.getService().coordinatorAborted(wrapper);
        }
        catch (WSATException wSATException) {
            void e;
            FFDCFilter.processException((Throwable)wSATException, (String)"com.ibm.ws.wsat.utils.WSATRequestHandler", (String)"198", (Object)this, (Object[])new Object[]{parameters, ctx});
            wrapper.getService().wsatFault(wrapper.getTxID(), WSATFault.getUnknownTransaction((String)e.getMessage()));
        }
    }
}

