/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wsat.webservice.client;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.jaxws.client.LibertyCustomizeBindingOutInterceptor;
import com.ibm.ws.jaxws.security.JaxWsSecurityConfigurationService;
import com.ibm.ws.jaxws.wsat.components.WSATConfigService;
import com.ibm.wsspi.ssl.SSLSupport;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.AbstractPhaseInterceptor;
import org.apache.cxf.transport.Conduit;
import org.apache.cxf.transport.http.HTTPConduit;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;

public class SSLClientInterceptor
extends AbstractPhaseInterceptor<Message> {
    final TraceComponent tc = Tr.register(SSLClientInterceptor.class, (String)"WSAT", null);

    public SSLClientInterceptor() {
        super("prepare-send");
        this.getAfter().add(LibertyCustomizeBindingOutInterceptor.class.getName());
    }

    public WSATConfigService getConfigService() {
        BundleContext context = FrameworkUtil.getBundle(WSATConfigService.class).getBundleContext();
        ServiceReference serviceRef = context.getServiceReference(WSATConfigService.class);
        if (serviceRef == null) {
            return null;
        }
        return (WSATConfigService)context.getService(serviceRef);
    }

    public SSLSupport getSSLSupportService() {
        BundleContext context = FrameworkUtil.getBundle(SSLSupport.class).getBundleContext();
        ServiceReference serviceRef = context.getServiceReference(SSLSupport.class);
        if (serviceRef == null) {
            return null;
        }
        return (SSLSupport)context.getService(serviceRef);
    }

    public JaxWsSecurityConfigurationService getJaxWsSecurityService() {
        BundleContext context = FrameworkUtil.getBundle(JaxWsSecurityConfigurationService.class).getBundleContext();
        ServiceReference serviceRef = context.getServiceReference(JaxWsSecurityConfigurationService.class);
        if (serviceRef == null) {
            throw new RuntimeException("JaxWsSecurity Service is not available, please make sure you have enabled appSecurity-2.0 feature and configured correct SSL setting");
        }
        return (JaxWsSecurityConfigurationService)context.getService(serviceRef);
    }

    public void handleMessage(Message message) throws Fault {
        Conduit conduit = message.getExchange().getConduit(message);
        SSLSupport sslService = this.getSSLSupportService();
        if (sslService == null) {
            throw new Fault("SSL support service is not available", this.tc.getLogger());
        }
        if (conduit instanceof HTTPConduit) {
            HTTPConduit httpConduit = (HTTPConduit)conduit;
            String sslId = this.getConfigService().getSSLReferenceId();
            boolean exist = sslService.getJSSEHelper().doesSSLConfigExist(sslId);
            if (!exist) {
                throw new Fault("SSL Reference ID [" + sslId + "] not exist", this.tc.getLogger());
            }
            try {
                JaxWsSecurityConfigurationService service = this.getJaxWsSecurityService();
                if (service == null) {
                    throw new Fault("JaxWsSecurity Service is not available, please make sure you have enabled appSecurity-2.0 feature and configured correct SSL setting", this.tc.getLogger());
                }
                service.configClientSSL((Conduit)httpConduit, sslId, null);
            }
            catch (Exception e) {
                throw new Fault((Throwable)e);
            }
        }
    }
}

