/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.cache.ehcache.internal;

import com.liferay.portal.cache.ehcache.internal.EhcachePortalCache;
import com.liferay.portal.cache.io.SerializableObjectWrapper;
import com.liferay.portal.kernel.cache.PortalCacheManager;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Element;

public class SerializableEhcachePortalCache<K extends Serializable, V>
extends EhcachePortalCache<K, V> {
    public SerializableEhcachePortalCache(PortalCacheManager<K, V> portalCacheManager, Ehcache ehcache) {
        super(portalCacheManager, ehcache);
    }

    @Override
    public List<K> getKeys() {
        List rawKeys = this.ehcache.getKeys();
        if (rawKeys.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Object> keys = new ArrayList<Object>(rawKeys.size());
        for (Object object : rawKeys) {
            keys.add(SerializableObjectWrapper.unwrap(object));
        }
        return keys;
    }

    protected Element createElement(K key, V value) {
        Object objectValue = value;
        if (value instanceof Serializable) {
            objectValue = new SerializableObjectWrapper((Serializable)value);
        }
        return new Element((Object)new SerializableObjectWrapper(key), objectValue);
    }

    @Override
    protected V doGet(K key) {
        Element element = this.ehcache.get((Serializable)new SerializableObjectWrapper(key));
        if (element == null) {
            return null;
        }
        return (V)SerializableObjectWrapper.unwrap((Object)element.getObjectValue());
    }

    @Override
    protected void doPut(K key, V value, int timeToLive) {
        Element element = this.createElement(key, value);
        if (timeToLive != 0) {
            element.setTimeToLive(timeToLive);
        }
        this.ehcache.put(element);
    }

    @Override
    protected V doPutIfAbsent(K key, V value, int timeToLive) {
        Element oldElement;
        Element element = this.createElement(key, value);
        if (timeToLive != 0) {
            element.setTimeToLive(timeToLive);
        }
        if ((oldElement = this.ehcache.putIfAbsent(element)) == null) {
            return null;
        }
        return (V)SerializableObjectWrapper.unwrap((Object)oldElement.getObjectValue());
    }

    @Override
    protected void doRemove(K key) {
        this.ehcache.remove((Serializable)new SerializableObjectWrapper(key));
    }

    @Override
    protected boolean doRemove(K key, V value) {
        return this.ehcache.removeElement(this.createElement(key, value));
    }

    @Override
    protected V doReplace(K key, V value, int timeToLive) {
        Element oldElement;
        Element element = this.createElement(key, value);
        if (timeToLive != 0) {
            element.setTimeToLive(timeToLive);
        }
        if ((oldElement = this.ehcache.replace(element)) == null) {
            return null;
        }
        return (V)SerializableObjectWrapper.unwrap((Object)oldElement.getObjectValue());
    }

    @Override
    protected boolean doReplace(K key, V oldValue, V newValue, int timeToLive) {
        Element newElement = this.createElement(key, newValue);
        if (timeToLive != 0) {
            newElement.setTimeToLive(timeToLive);
        }
        return this.ehcache.replace(this.createElement(key, oldValue), newElement);
    }
}

