/*
 * Decompiled with CFR 0.152.
 */
package com.helger.pdflayout.spec;

import com.helger.commons.annotation.MustImplementEqualsAndHashcode;
import com.helger.commons.equals.EqualsHelper;
import com.helger.pdflayout.PLConvert;
import com.helger.pdflayout.spec.AbstractRectSpec;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;

@Immutable
@MustImplementEqualsAndHashcode
public class MarginSpec
extends AbstractRectSpec {
    public static final float DEFAULT_FLOAT = 0.0f;
    public static final MarginSpec MARGIN0 = new MarginSpec(0.0f, 0.0f, 0.0f, 0.0f);

    public MarginSpec(@Nonnull AbstractRectSpec abstractRectSpec) {
        super(abstractRectSpec);
    }

    public MarginSpec(float f) {
        this(f, f);
    }

    public MarginSpec(float f, float f2) {
        this(f, f2, f, f2);
    }

    public MarginSpec(float f, float f2, float f3, float f4) {
        super(f, f2, f3, f4);
    }

    @Nonnull
    public MarginSpec getCloneWithTop(float f) {
        if (EqualsHelper.equals((float)f, (float)this.m_fTop)) {
            return this;
        }
        return new MarginSpec(f, this.m_fRight, this.m_fBottom, this.m_fLeft);
    }

    @Nonnull
    public MarginSpec getCloneWithRight(float f) {
        if (EqualsHelper.equals((float)f, (float)this.m_fRight)) {
            return this;
        }
        return new MarginSpec(this.m_fTop, f, this.m_fBottom, this.m_fLeft);
    }

    @Nonnull
    public MarginSpec getCloneWithBottom(float f) {
        if (EqualsHelper.equals((float)f, (float)this.m_fBottom)) {
            return this;
        }
        return new MarginSpec(this.m_fTop, this.m_fRight, f, this.m_fLeft);
    }

    @Nonnull
    public MarginSpec getCloneWithLeft(float f) {
        if (EqualsHelper.equals((float)f, (float)this.m_fLeft)) {
            return this;
        }
        return new MarginSpec(this.m_fTop, this.m_fRight, this.m_fBottom, f);
    }

    @Nonnull
    public static MarginSpec createMM(float f) {
        return new MarginSpec(PLConvert.mm2units(f));
    }

    @Nonnull
    public static MarginSpec createMM(float f, float f2) {
        return new MarginSpec(PLConvert.mm2units(f), PLConvert.mm2units(f2));
    }

    @Nonnull
    public static MarginSpec createMM(float f, float f2, float f3, float f4) {
        return new MarginSpec(PLConvert.mm2units(f), PLConvert.mm2units(f2), PLConvert.mm2units(f3), PLConvert.mm2units(f4));
    }

    @Nonnull
    public static MarginSpec top(float f) {
        return new MarginSpec(f, 0.0f, 0.0f, 0.0f);
    }

    @Nonnull
    public static MarginSpec right(float f) {
        return new MarginSpec(0.0f, f, 0.0f, 0.0f);
    }

    @Nonnull
    public static MarginSpec bottom(float f) {
        return new MarginSpec(0.0f, 0.0f, f, 0.0f);
    }

    @Nonnull
    public static MarginSpec left(float f) {
        return new MarginSpec(0.0f, 0.0f, 0.0f, f);
    }
}

