/*
 * Decompiled with CFR 0.152.
 */
package com.helger.pdflayout.spec;

import com.helger.collection.map.IntFloatMap;
import com.helger.collection.map.IntObjectMap;
import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.MustImplementEqualsAndHashcode;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.io.stream.NonBlockingByteArrayOutputStream;
import com.helger.commons.string.StringHelper;
import com.helger.commons.string.ToStringGenerator;
import com.helger.pdflayout.PLConvert;
import com.helger.pdflayout.debug.PLDebugLog;
import com.helger.pdflayout.spec.TextAndWidthSpec;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.List;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.WillNotClose;
import javax.annotation.concurrent.Immutable;
import org.apache.pdfbox.pdmodel.font.PDCIDFont;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.font.PDFontDescriptor;
import org.apache.pdfbox.pdmodel.font.PDFontHelper;
import org.apache.pdfbox.pdmodel.font.PDType0Font;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Immutable
@MustImplementEqualsAndHashcode
public class LoadedFont {
    private static final Logger LOGGER = LoggerFactory.getLogger(LoadedFont.class);
    private final PDFont m_aFont;
    private final int m_nFallbackCodePoint;
    private final float m_fBBHeight;
    private final float m_fDescent;
    private final boolean m_bFontWillBeSubset;
    private final IntObjectMap<EncodedCodePoint> m_aEncodedCodePointCache = new IntObjectMap();
    private final IntFloatMap m_aCodePointWidthCache = new IntFloatMap();

    public LoadedFont(@Nonnull PDFont pDFont, int n) {
        PDCIDFont pDCIDFont;
        ValueEnforcer.notNull((Object)pDFont, (String)"Font");
        this.m_aFont = pDFont;
        this.m_nFallbackCodePoint = n;
        PDFontDescriptor pDFontDescriptor = pDFont.getFontDescriptor();
        if (pDFontDescriptor == null && pDFont instanceof PDType0Font && (pDCIDFont = ((PDType0Font)pDFont).getDescendantFont()) != null) {
            pDFontDescriptor = pDCIDFont.getFontDescriptor();
        }
        if (pDFontDescriptor == null) {
            throw new IllegalArgumentException("Failed to determine FontDescriptor from specified font " + pDFont);
        }
        this.m_fBBHeight = pDFontDescriptor.getFontBoundingBox().getHeight();
        this.m_fDescent = pDFontDescriptor.getDescent();
        this.m_bFontWillBeSubset = this.m_aFont.willBeSubset();
    }

    @Nonnull
    public final PDFont getFont() {
        return this.m_aFont;
    }

    @Nonnegative
    public final float getDescent(@Nonnegative float f) {
        return PLConvert.getWidthForFontSize(this.m_fDescent, f);
    }

    @Nonnegative
    public final float getTextHeight(@Nonnegative float f) {
        return PLConvert.getWidthForFontSize(this.m_fBBHeight, f);
    }

    @Nonnull
    public static EncodedCodePoint encodeCodepointWithFallback(@Nonnull PDFont pDFont, int n, int n2) throws IOException {
        try {
            byte[] byArray = PDFontHelper.encode(pDFont, n);
            return new EncodedCodePoint(n, byArray);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            if (PLDebugLog.isDebugFont()) {
                PLDebugLog.debugFont(pDFont.toString(), "No code point " + n + " in this font - " + illegalArgumentException.getMessage());
            }
            try {
                byte[] byArray = PDFontHelper.encode(pDFont, n2);
                return new EncodedCodePoint(n2, byArray);
            }
            catch (IllegalArgumentException illegalArgumentException2) {
                if (PLDebugLog.isDebugFont()) {
                    PLDebugLog.debugFont(pDFont.toString(), "No fallback code point " + n2 + " in this font - " + illegalArgumentException2.getMessage());
                }
                throw illegalArgumentException2;
            }
        }
    }

    @Nonnull
    private EncodedCodePoint _getEncodedCodePoint(int n) throws IOException {
        EncodedCodePoint encodedCodePoint = (EncodedCodePoint)this.m_aEncodedCodePointCache.get(n);
        if (encodedCodePoint == null) {
            encodedCodePoint = LoadedFont.encodeCodepointWithFallback(this.m_aFont, n, this.m_nFallbackCodePoint);
            this.m_aEncodedCodePointCache.put(n, (Object)encodedCodePoint);
        }
        return encodedCodePoint;
    }

    private float _getCodePointWidth(int n) throws IOException {
        float f = this.m_aCodePointWidthCache.get(n, -1.0f);
        if (f < 0.0f) {
            EncodedCodePoint encodedCodePoint = this._getEncodedCodePoint(n);
            f = this.m_aFont.getWidth(encodedCodePoint.getEncodedIntValue());
            this.m_aCodePointWidthCache.put(n, f);
        }
        return f;
    }

    @Nonnegative
    public float getStringWidth(@Nonnull String string, @Nonnegative float f) throws IOException {
        float f2 = 0.0f;
        int n = 0;
        int n2 = string.length();
        while (n < n2) {
            int n3 = string.codePointAt(n);
            n += Character.charCount(n3);
            f2 += this._getCodePointWidth(n3);
        }
        return PLConvert.getWidthForFontSize(f2, f);
    }

    @Nonnull
    public byte[] getEncodedForPageContentStream(@Nonnull String string) throws IOException {
        try (NonBlockingByteArrayOutputStream nonBlockingByteArrayOutputStream = new NonBlockingByteArrayOutputStream(string.length() * 2);){
            int n = 0;
            while (n < string.length()) {
                int n2 = string.codePointAt(n);
                n += Character.charCount(n2);
                EncodedCodePoint encodedCodePoint = this._getEncodedCodePoint(n2);
                if (this.m_bFontWillBeSubset) {
                    this.m_aFont.addToSubset(encodedCodePoint.getCodePoint());
                }
                encodedCodePoint.writeEncodedBytes((OutputStream)nonBlockingByteArrayOutputStream);
            }
            byte[] byArray = nonBlockingByteArrayOutputStream.toByteArray();
            return byArray;
        }
    }

    private void _getLineFitToWidthForward(@Nonnull String string, @Nonnegative float f, @Nonnegative float f2, @Nonnull List<TextAndWidthSpec> list) throws IOException {
        String string2 = string;
        float f3 = 0.0f;
        int n = 0;
        float f4 = 0.0f;
        int n2 = 0;
        boolean bl = false;
        while (n < string2.length()) {
            float f5;
            boolean bl2;
            int n3 = string2.codePointAt(n);
            float f6 = PLConvert.getWidthForFontSize(this._getCodePointWidth(n3), f);
            if (Character.isWhitespace(n3)) {
                n2 = n;
                f4 = f3;
            }
            boolean bl3 = bl2 = (f5 = f3 + f6) > f2;
            if (bl2 && n == 0) {
                if (!bl) {
                    LOGGER.warn("The provided max width (" + f2 + ") is too small to hold a single character! Will create an overlap! Problem string=<" + string + ">");
                    bl = true;
                }
                bl2 = false;
            }
            if (bl2) {
                String string3;
                if (n2 > 0) {
                    string3 = string2.substring(0, n2);
                    string2 = string2.substring(n2 + 1);
                    list.add(new TextAndWidthSpec(string3, f4));
                } else {
                    string3 = string2.substring(0, n);
                    string2 = string2.substring(n);
                    list.add(new TextAndWidthSpec(string3, f3));
                }
                f3 = 0.0f;
                n = 0;
                f4 = 0.0f;
                n2 = 0;
                continue;
            }
            n += Character.charCount(n3);
            f3 = f5;
        }
        list.add(new TextAndWidthSpec(string2, f3));
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<TextAndWidthSpec> getFitToWidth(@Nullable String string, @Nonnegative float f, @Nonnegative float f2) throws IOException {
        ValueEnforcer.isGT0((float)f, (String)"FontSize");
        ValueEnforcer.isGT0((float)f2, (String)"MaxWidth");
        String[] stringArray = StringHelper.getExplodedArray((char)'\n', (String)string);
        CommonsArrayList commonsArrayList = new CommonsArrayList();
        for (String string2 : stringArray) {
            this._getLineFitToWidthForward(string2, f, f2, (List<TextAndWidthSpec>)commonsArrayList);
        }
        return commonsArrayList;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        LoadedFont loadedFont = (LoadedFont)object;
        return this.m_aFont.equals((Object)loadedFont.m_aFont);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append((Object)this.m_aFont).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("Font", (Object)this.m_aFont).append("FallbackCodePoint", this.m_nFallbackCodePoint).append("BBHeight", this.m_fBBHeight).append("Descent", this.m_fDescent).append("FontWillBeSubset", this.m_bFontWillBeSubset).getToString();
    }

    private static final class EncodedCodePoint
    implements Serializable {
        private final int m_nCodePoint;
        private final byte[] m_aEncoded;
        private Integer m_aEncodedValue;

        private static int _toInt(@Nonnull byte[] byArray) {
            int n = 0;
            for (byte by : byArray) {
                n <<= 8;
                n |= (by + 256) % 256;
            }
            return n;
        }

        private EncodedCodePoint(int n, @Nonnull byte[] byArray) {
            this.m_nCodePoint = n;
            this.m_aEncoded = byArray;
        }

        public int getCodePoint() {
            return this.m_nCodePoint;
        }

        public void writeEncodedBytes(@Nonnull @WillNotClose OutputStream outputStream) throws IOException {
            outputStream.write(this.m_aEncoded);
        }

        public int getEncodedIntValue() {
            Integer n = this.m_aEncodedValue;
            if (n == null) {
                n = this.m_aEncodedValue = Integer.valueOf(EncodedCodePoint._toInt(this.m_aEncoded));
            }
            return n;
        }
    }
}

