/*
 * Decompiled with CFR 0.152.
 */
package com.helger.pdflayout.spec;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.MustImplementEqualsAndHashcode;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.ArrayHelper;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.string.ToStringGenerator;
import java.io.Serializable;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSFloat;

@MustImplementEqualsAndHashcode
public class LineDashPatternSpec
implements Serializable {
    public static final LineDashPatternSpec SOLID = new LineDashPatternSpec();
    public static final LineDashPatternSpec DASHED_2 = new LineDashPatternSpec(2.0f);
    public static final LineDashPatternSpec DASHED_3 = new LineDashPatternSpec(3.0f);
    public static final LineDashPatternSpec DASHED_4 = new LineDashPatternSpec(4.0f);
    public static final LineDashPatternSpec DASHED_5 = new LineDashPatternSpec(5.0f);
    private final float[] m_aPattern;
    private final float m_fPhase;

    public LineDashPatternSpec() {
        this(new float[0], 0.0f);
    }

    public LineDashPatternSpec(@Nonnegative float f) {
        this(new float[]{f}, 0.0f);
    }

    public LineDashPatternSpec(@Nonnegative float f, @Nonnegative float f2) {
        this(new float[]{f, f2}, 0.0f);
    }

    public LineDashPatternSpec(@Nonnull float[] fArray, float f) {
        ValueEnforcer.notNull((Object)fArray, (String)"Pattern");
        ValueEnforcer.isTrue((fArray.length <= 2 ? 1 : 0) != 0, () -> "Too many patterns (" + fArray.length + ") provided. At max 2 items are allowed.");
        for (float f2 : fArray) {
            ValueEnforcer.isGT0((float)f2, (String)"PatternValue");
        }
        this.m_aPattern = ArrayHelper.getCopy((float[])fArray);
        this.m_fPhase = f;
    }

    @Nonnull
    @ReturnsMutableCopy
    public final float[] getPattern() {
        return ArrayHelper.getCopy((float[])this.m_aPattern);
    }

    @Nonnull
    @ReturnsMutableCopy
    public final COSArray getPatternCOSArray() {
        COSArray cOSArray = new COSArray();
        for (float f : this.m_aPattern) {
            cOSArray.add((COSBase)new COSFloat(f));
        }
        return cOSArray;
    }

    public final float getPhase() {
        return this.m_fPhase;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        LineDashPatternSpec lineDashPatternSpec = (LineDashPatternSpec)object;
        return EqualsHelper.equals((Object)this.m_aPattern, (Object)lineDashPatternSpec.m_aPattern) && EqualsHelper.equals((float)this.m_fPhase, (float)lineDashPatternSpec.m_fPhase);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append(this.m_aPattern).append(this.m_fPhase).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("pattern", this.m_aPattern).append("phase", this.m_fPhase).getToString();
    }
}

