/*
 * Decompiled with CFR 0.152.
 */
package com.helger.pdflayout.spec;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.MustImplementEqualsAndHashcode;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.string.ToStringGenerator;
import com.helger.pdflayout.base.PLColor;
import com.helger.pdflayout.spec.LineDashPatternSpec;
import java.io.Serializable;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;

@Immutable
@MustImplementEqualsAndHashcode
public class BorderStyleSpec
implements Serializable {
    public static final PLColor DEFAULT_COLOR = PLColor.BLACK;
    public static final LineDashPatternSpec DEFAULT_LINE_DASH_PATTERN = LineDashPatternSpec.SOLID;
    public static final float DEFAULT_LINE_WIDTH = 1.0f;
    public static final BorderStyleSpec EMPTY = new BorderStyleSpec();
    private final PLColor m_aColor;
    private final LineDashPatternSpec m_aLineDashPattern;
    private final float m_fLineWidth;

    public BorderStyleSpec() {
        this(DEFAULT_COLOR, DEFAULT_LINE_DASH_PATTERN, 1.0f);
    }

    public BorderStyleSpec(@Nonnull PLColor pLColor) {
        this(pLColor, DEFAULT_LINE_DASH_PATTERN, 1.0f);
    }

    public BorderStyleSpec(@Nonnull LineDashPatternSpec lineDashPatternSpec) {
        this(DEFAULT_COLOR, lineDashPatternSpec, 1.0f);
    }

    public BorderStyleSpec(float f) {
        this(DEFAULT_COLOR, DEFAULT_LINE_DASH_PATTERN, f);
    }

    public BorderStyleSpec(@Nonnull PLColor pLColor, float f) {
        this(pLColor, DEFAULT_LINE_DASH_PATTERN, f);
    }

    public BorderStyleSpec(@Nonnull PLColor pLColor, @Nonnull LineDashPatternSpec lineDashPatternSpec) {
        this(pLColor, lineDashPatternSpec, 1.0f);
    }

    public BorderStyleSpec(@Nonnull PLColor pLColor, @Nonnull LineDashPatternSpec lineDashPatternSpec, @Nonnegative float f) {
        ValueEnforcer.notNull((Object)pLColor, (String)"Color");
        ValueEnforcer.notNull((Object)lineDashPatternSpec, (String)"LineDashPattern");
        ValueEnforcer.isFalse((boolean)Float.isNaN(f), (String)"LineWidth may not be NaN");
        ValueEnforcer.isGE0((float)f, (String)"LineWidth");
        this.m_aColor = pLColor;
        this.m_aLineDashPattern = lineDashPatternSpec;
        this.m_fLineWidth = f;
    }

    @Nonnull
    public final PLColor getColor() {
        return this.m_aColor;
    }

    @Nonnull
    public final LineDashPatternSpec getLineDashPattern() {
        return this.m_aLineDashPattern;
    }

    @Nonnegative
    public final float getLineWidth() {
        return this.m_fLineWidth;
    }

    public final boolean isDefault() {
        return this.m_aColor.equals(DEFAULT_COLOR) && this.m_aLineDashPattern.equals(DEFAULT_LINE_DASH_PATTERN) && EqualsHelper.equals((float)this.m_fLineWidth, (float)1.0f);
    }

    @Nonnull
    public BorderStyleSpec getCloneWithColor(@Nonnull PLColor pLColor) {
        ValueEnforcer.notNull((Object)pLColor, (String)"NewColor");
        if (pLColor.equals(this.m_aColor)) {
            return this;
        }
        return new BorderStyleSpec(pLColor, this.m_aLineDashPattern, this.m_fLineWidth);
    }

    @Nonnull
    public BorderStyleSpec getCloneWithLineDashPattern(@Nonnull LineDashPatternSpec lineDashPatternSpec) {
        ValueEnforcer.notNull((Object)lineDashPatternSpec, (String)"NewLineDashPattern");
        if (lineDashPatternSpec.equals(this.m_aLineDashPattern)) {
            return this;
        }
        return new BorderStyleSpec(this.m_aColor, lineDashPatternSpec, this.m_fLineWidth);
    }

    @Nonnull
    public BorderStyleSpec getCloneWithLineWidth(float f) {
        ValueEnforcer.isFalse((boolean)Float.isNaN(f), (String)"LineWidth may not be NaN");
        ValueEnforcer.isGE0((float)f, (String)"LineWidth");
        if (EqualsHelper.equals((float)f, (float)this.m_fLineWidth)) {
            return this;
        }
        return new BorderStyleSpec(this.m_aColor, this.m_aLineDashPattern, f);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        BorderStyleSpec borderStyleSpec = (BorderStyleSpec)object;
        return this.m_aColor.equals(borderStyleSpec.m_aColor) && this.m_aLineDashPattern.equals(borderStyleSpec.m_aLineDashPattern) && EqualsHelper.equals((float)this.m_fLineWidth, (float)borderStyleSpec.m_fLineWidth);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append((Object)this.m_aColor).append((Object)this.m_aLineDashPattern).append(this.m_fLineWidth).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("Color", (Object)this.m_aColor).append("LineDashPattern", (Object)this.m_aLineDashPattern).append("LineWidth", this.m_fLineWidth).getToString();
    }
}

