/*
 * Decompiled with CFR 0.152.
 */
package com.helger.pdflayout.element.table;

import com.helger.commons.ValueEnforcer;
import com.helger.pdflayout.base.IPLRenderableObject;
import com.helger.pdflayout.element.box.AbstractPLBox;
import com.helger.pdflayout.element.special.PLSpacerX;
import com.helger.pdflayout.render.PageRenderContext;
import java.io.IOException;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.OverridingMethodsMustInvokeSuper;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class PLTableCell
extends AbstractPLBox<PLTableCell> {
    public static final int DEFAULT_COL_SPAN = 1;
    private int m_nColSpan;

    public PLTableCell(@Nullable IPLRenderableObject<?> iPLRenderableObject) {
        this(iPLRenderableObject, 1);
    }

    public PLTableCell(@Nullable IPLRenderableObject<?> iPLRenderableObject, @Nonnegative int n) {
        super(iPLRenderableObject);
        this._setColSpan(n);
        this.setVertSplittable(true);
    }

    @Override
    @Nonnull
    @OverridingMethodsMustInvokeSuper
    public PLTableCell setBasicDataFrom(@Nonnull PLTableCell pLTableCell) {
        super.setBasicDataFrom(pLTableCell);
        this._setColSpan(pLTableCell.getColSpan());
        return this;
    }

    @Nonnegative
    public int getColSpan() {
        return this.m_nColSpan;
    }

    private void _setColSpan(@Nonnegative int n) {
        ValueEnforcer.isGT0((int)n, (String)"ColSpan");
        this.m_nColSpan = n;
    }

    @Override
    @Nonnull
    public PLTableCell internalCreateNewVertSplitObject(@Nonnull PLTableCell pLTableCell) {
        PLTableCell pLTableCell2 = new PLTableCell(null, pLTableCell.getColSpan());
        pLTableCell2.setBasicDataFrom(pLTableCell);
        return pLTableCell2;
    }

    @Override
    protected void onRender(@Nonnull PageRenderContext pageRenderContext) throws IOException {
        super.onRender(pageRenderContext);
    }

    @Nonnull
    public static PLTableCell createEmptyCell() {
        return new PLTableCell(new PLSpacerX());
    }

    @Nonnull
    public static PLTableCell createEmptyCell(@Nonnegative int n) {
        return new PLTableCell(new PLSpacerX(), n);
    }

    @Nonnull
    public static PLTableCell[] createEmptyCells(@Nonnegative int n) {
        ValueEnforcer.isGE0((int)n, (String)"CellCount");
        PLTableCell[] pLTableCellArray = new PLTableCell[n];
        for (int i = 0; i < n; ++i) {
            pLTableCellArray[i] = PLTableCell.createEmptyCell();
        }
        return pLTableCellArray;
    }
}

