/*
 * Decompiled with CFR 0.152.
 */
package com.helger.pdflayout.element.link;

import com.helger.commons.string.StringHelper;
import com.helger.pdflayout.base.IPLRenderableObject;
import com.helger.pdflayout.base.PLColor;
import com.helger.pdflayout.debug.PLDebugLog;
import com.helger.pdflayout.element.box.AbstractPLInlineBox;
import com.helger.pdflayout.link.ELinkBorderStyle;
import com.helger.pdflayout.render.PageRenderContext;
import com.helger.pdflayout.spec.LineDashPatternSpec;
import java.io.IOException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.OverridingMethodsMustInvokeSuper;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.interactive.action.PDAction;
import org.apache.pdfbox.pdmodel.interactive.action.PDActionURI;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAnnotationLink;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDBorderStyleDictionary;

public abstract class AbstractPLExternalLink<IMPLTYPE extends AbstractPLExternalLink<IMPLTYPE>>
extends AbstractPLInlineBox<IMPLTYPE> {
    private String m_sURI;
    private final ELinkBorderStyle m_eLinkBorderStyle = ELinkBorderStyle.SOLID;
    private final LineDashPatternSpec m_aLinkDashPattern = null;
    private final float m_fLinkBorderWidth = 0.0f;
    private final PLColor m_aLinkColor = null;

    public AbstractPLExternalLink(@Nullable IPLRenderableObject<?> iPLRenderableObject) {
        super(iPLRenderableObject);
    }

    @Override
    @Nonnull
    @OverridingMethodsMustInvokeSuper
    public IMPLTYPE setBasicDataFrom(@Nonnull IMPLTYPE IMPLTYPE) {
        super.setBasicDataFrom(IMPLTYPE);
        this.setURI(((AbstractPLExternalLink)IMPLTYPE).getURI());
        return (IMPLTYPE)((AbstractPLExternalLink)this.thisAsT());
    }

    @Nullable
    public final String getURI() {
        return this.m_sURI;
    }

    @Nonnull
    public final IMPLTYPE setURI(@Nullable String string) {
        this.internalCheckNotPrepared();
        this.m_sURI = string;
        return (IMPLTYPE)((AbstractPLExternalLink)this.thisAsT());
    }

    @Override
    protected void onRender(@Nonnull PageRenderContext pageRenderContext) throws IOException {
        super.onRender(pageRenderContext);
        IPLRenderableObject<?> iPLRenderableObject = this.getElement();
        if (iPLRenderableObject != null) {
            if (StringHelper.hasText((String)this.m_sURI)) {
                PDAnnotationLink pDAnnotationLink = new PDAnnotationLink();
                PDBorderStyleDictionary pDBorderStyleDictionary = new PDBorderStyleDictionary();
                if (this.m_eLinkBorderStyle != null) {
                    pDBorderStyleDictionary.setStyle(this.m_eLinkBorderStyle.getID());
                }
                if (this.m_aLinkDashPattern != null) {
                    pDBorderStyleDictionary.setDashStyle(this.m_aLinkDashPattern.getPatternCOSArray());
                }
                pDBorderStyleDictionary.setWidth(0.0f);
                pDAnnotationLink.setBorderStyle(pDBorderStyleDictionary);
                if (this.m_aLinkColor != null) {
                    pDAnnotationLink.setColor(this.m_aLinkColor.getAsPDColor());
                }
                PDActionURI pDActionURI = new PDActionURI();
                pDActionURI.setURI(this.m_sURI);
                pDAnnotationLink.setAction((PDAction)pDActionURI);
                float f = this.getRenderHeight() + this.getBorderYSumWidth() + this.getPaddingYSum();
                PDRectangle pDRectangle = new PDRectangle(pageRenderContext.getStartLeft() + this.getMarginLeft(), pageRenderContext.getStartTop() - this.getMarginTop() - f, this.getRenderWidth() + this.getBorderXSumWidth() + this.getPaddingXSum(), f);
                pDAnnotationLink.setRectangle(pDRectangle);
                pageRenderContext.getContentStream().getPage().getAnnotations().add(pDAnnotationLink);
            } else {
                PLDebugLog.debugRender(this, "Not rendering an external link, because no URI is present");
            }
        } else {
            PLDebugLog.debugRender(this, "Not rendering an external link, because no element is contained");
        }
    }
}

