/*
 * Decompiled with CFR 0.152.
 */
package com.helger.pdflayout.element.image;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.string.ToStringGenerator;
import com.helger.pdflayout.element.image.AbstractPLImage;
import com.helger.pdflayout.render.PagePreRenderContext;
import java.awt.image.BufferedImage;
import java.io.IOException;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.OverridingMethodsMustInvokeSuper;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.graphics.image.CCITTFactory;
import org.apache.pdfbox.pdmodel.graphics.image.JPEGFactory;
import org.apache.pdfbox.pdmodel.graphics.image.LosslessFactory;
import org.apache.pdfbox.pdmodel.graphics.image.PDImageXObject;

public class PLImage
extends AbstractPLImage<PLImage> {
    private final BufferedImage m_aImage;

    public PLImage(@Nonnull BufferedImage bufferedImage) {
        this(bufferedImage, bufferedImage.getWidth(), bufferedImage.getHeight());
    }

    public PLImage(@Nonnull BufferedImage bufferedImage, @Nonnegative float f, @Nonnegative float f2) {
        super(f, f2);
        ValueEnforcer.notNull((Object)bufferedImage, (String)"Image");
        this.m_aImage = bufferedImage;
    }

    @Override
    @Nonnull
    @OverridingMethodsMustInvokeSuper
    public PLImage setBasicDataFrom(@Nonnull PLImage pLImage) {
        super.setBasicDataFrom(pLImage);
        return this;
    }

    @Nullable
    public BufferedImage getImage() {
        return this.m_aImage;
    }

    @Override
    @Nonnull
    protected PDImageXObject getXObject(@Nonnull PagePreRenderContext pagePreRenderContext) throws IOException {
        switch (this.getImageType()) {
            case CCITT: {
                return CCITTFactory.createFromImage((PDDocument)pagePreRenderContext.getDocument(), (BufferedImage)this.m_aImage);
            }
            case JPEG: {
                return JPEGFactory.createFromImage((PDDocument)pagePreRenderContext.getDocument(), (BufferedImage)this.m_aImage);
            }
            case LOSSLESS: {
                return LosslessFactory.createFromImage((PDDocument)pagePreRenderContext.getDocument(), (BufferedImage)this.m_aImage);
            }
        }
        throw new IllegalStateException("Unsupported image type: " + this.toString());
    }

    @Override
    public String toString() {
        return ToStringGenerator.getDerived((String)super.toString()).append("Image", (Object)this.m_aImage).getToString();
    }
}

