/*
 * Decompiled with CFR 0.152.
 */
package com.helger.pdflayout.element.image;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.state.EChange;
import com.helger.commons.string.ToStringGenerator;
import com.helger.pdflayout.base.AbstractPLInlineElement;
import com.helger.pdflayout.element.image.EPLImageType;
import com.helger.pdflayout.pdfbox.PDPageContentStreamWithCache;
import com.helger.pdflayout.render.PLRenderHelper;
import com.helger.pdflayout.render.PagePreRenderContext;
import com.helger.pdflayout.render.PageRenderContext;
import com.helger.pdflayout.render.PreparationContext;
import com.helger.pdflayout.spec.SizeSpec;
import java.io.IOException;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.OverridingMethodsMustInvokeSuper;
import org.apache.pdfbox.pdmodel.graphics.image.PDImageXObject;

public abstract class AbstractPLImage<IMPLTYPE extends AbstractPLImage<IMPLTYPE>>
extends AbstractPLInlineElement<IMPLTYPE> {
    public static final EPLImageType DEFAULT_IMAGE_TYPE = EPLImageType.JPEG;
    private final float m_fImageWidth;
    private final float m_fImageHeight;
    private EPLImageType m_eImageType = DEFAULT_IMAGE_TYPE;
    private PDImageXObject m_aXObject;

    public AbstractPLImage(@Nonnegative float f, @Nonnegative float f2) {
        ValueEnforcer.isGT0((float)f, (String)"ImageWidth");
        ValueEnforcer.isGT0((float)f2, (String)"ImageHeight");
        this.m_fImageWidth = f;
        this.m_fImageHeight = f2;
    }

    @Override
    @Nonnull
    @OverridingMethodsMustInvokeSuper
    public IMPLTYPE setBasicDataFrom(@Nonnull IMPLTYPE IMPLTYPE) {
        super.setBasicDataFrom(IMPLTYPE);
        return (IMPLTYPE)((AbstractPLImage)this.thisAsT());
    }

    @Nonnegative
    public final float getImageWidth() {
        return this.m_fImageWidth;
    }

    @Nonnegative
    public final float getImageHeight() {
        return this.m_fImageHeight;
    }

    @Nonnull
    public final EPLImageType getImageType() {
        return this.m_eImageType;
    }

    @Nonnull
    public final IMPLTYPE setImageType(@Nonnull EPLImageType ePLImageType) {
        ValueEnforcer.notNull((Object)((Object)ePLImageType), (String)"ImageType");
        this.m_eImageType = ePLImageType;
        return (IMPLTYPE)((AbstractPLImage)this.thisAsT());
    }

    @Override
    protected SizeSpec onPrepare(@Nonnull PreparationContext preparationContext) {
        return new SizeSpec(this.m_fImageWidth, this.m_fImageHeight);
    }

    @Override
    protected void onMarkAsNotPrepared() {
    }

    @Nonnull
    protected abstract PDImageXObject getXObject(@Nonnull PagePreRenderContext var1) throws IOException;

    @Override
    @Nonnull
    public EChange beforeRender(@Nonnull PagePreRenderContext pagePreRenderContext) {
        try {
            this.m_aXObject = this.getXObject(pagePreRenderContext);
            if (this.m_aXObject == null) {
                throw new IllegalStateException("Failed to create PDImageXObject");
            }
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException("Failed to create JPEG", iOException);
        }
        return EChange.UNCHANGED;
    }

    @Override
    protected void onRender(@Nonnull PageRenderContext pageRenderContext) throws IOException {
        PLRenderHelper.fillAndRenderBorder((AbstractPLImage)this.thisAsT(), pageRenderContext, 0.0f, 0.0f);
        PDPageContentStreamWithCache pDPageContentStreamWithCache = pageRenderContext.getContentStream();
        pDPageContentStreamWithCache.drawXObject(this.m_aXObject, pageRenderContext.getStartLeft() + this.getOutlineLeft(), pageRenderContext.getStartTop() - this.getOutlineTop() - this.m_fImageHeight, this.m_fImageWidth, this.m_fImageHeight);
    }

    @Override
    public String toString() {
        return ToStringGenerator.getDerived((String)super.toString()).append("ImageWidth", this.m_fImageWidth).append("ImageHeight", this.m_fImageHeight).append("ImageType", (Enum)this.m_eImageType).getToString();
    }
}

