/*
 * Decompiled with CFR 0.152.
 */
package com.helger.pdflayout.config.xml;

import com.helger.pdflayout.spec.TextAndWidthSpec;
import com.helger.xml.microdom.IMicroElement;
import com.helger.xml.microdom.MicroElement;
import com.helger.xml.microdom.convert.IMicroTypeConverter;
import com.helger.xml.microdom.util.MicroHelper;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class TextAndWidthSpecMicroTypeConverter
implements IMicroTypeConverter<TextAndWidthSpec> {
    private static final String ELEMENT_TEXT = "text";
    private static final String ATTR_WIDTH = "width";

    @Nonnull
    public IMicroElement convertToMicroElement(@Nonnull TextAndWidthSpec textAndWidthSpec, @Nullable String string, @Nonnull String string2) {
        MicroElement microElement = new MicroElement(string, string2);
        microElement.setAttribute(ATTR_WIDTH, textAndWidthSpec.getWidth());
        microElement.appendElement(string, ELEMENT_TEXT).appendText((CharSequence)textAndWidthSpec.getText());
        return microElement;
    }

    @Nonnull
    public TextAndWidthSpec convertToNative(@Nonnull IMicroElement iMicroElement) {
        String string = MicroHelper.getChildTextContent((IMicroElement)iMicroElement, (String)ELEMENT_TEXT);
        float f = iMicroElement.getAttributeValueAsFloat(ATTR_WIDTH, Float.NaN);
        return new TextAndWidthSpec(string, f);
    }
}

