/*
 * Decompiled with CFR 0.152.
 */
package com.helger.pdflayout.config.xml;

import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.string.StringParser;
import com.helger.pdflayout.spec.LineDashPatternSpec;
import com.helger.xml.microdom.IMicroElement;
import com.helger.xml.microdom.MicroElement;
import com.helger.xml.microdom.convert.IMicroTypeConverter;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class LineDashPatternSpecMicroTypeConverter
implements IMicroTypeConverter<LineDashPatternSpec> {
    private static final String ATTR_PHASE = "phase";
    private static final String ELEMENT_PATTERN = "pattern";
    private static final String ATTR_ITEM = "item";

    @Nonnull
    public IMicroElement convertToMicroElement(@Nonnull LineDashPatternSpec lineDashPatternSpec, @Nullable String string, @Nonnull String string2) {
        MicroElement microElement = new MicroElement(string, string2);
        microElement.setAttribute(ATTR_PHASE, lineDashPatternSpec.getPhase());
        for (float f : lineDashPatternSpec.getPattern()) {
            microElement.appendElement(string, ELEMENT_PATTERN).setAttribute(ATTR_ITEM, f);
        }
        return microElement;
    }

    @Nonnull
    public LineDashPatternSpec convertToNative(@Nonnull IMicroElement iMicroElement) {
        float f = StringParser.parseFloat((String)iMicroElement.getAttributeValue(ATTR_PHASE), (float)Float.NaN);
        ICommonsList iCommonsList = iMicroElement.getAllChildElements(ELEMENT_PATTERN);
        float[] fArray = new float[iCommonsList.size()];
        int n = 0;
        for (IMicroElement iMicroElement2 : iCommonsList) {
            fArray[n] = iMicroElement2.getAttributeValueAsFloat(ATTR_ITEM, Float.NaN);
            if (Float.isNaN(fArray[n])) {
                fArray[n] = iMicroElement2.getAttributeValueAsFloat("patternitem", Float.NaN);
            }
            ++n;
        }
        return new LineDashPatternSpec(fArray, f);
    }
}

