/*
 * Decompiled with CFR 0.152.
 */
package com.helger.pdflayout.config.xml;

import com.helger.pdflayout.spec.EValueUOMType;
import com.helger.pdflayout.spec.HeightSpec;
import com.helger.xml.microdom.IMicroElement;
import com.helger.xml.microdom.MicroElement;
import com.helger.xml.microdom.convert.IMicroTypeConverter;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class HeightSpecMicroTypeConverter
implements IMicroTypeConverter<HeightSpec> {
    private static final String ATTR_TYPE = "type";
    private static final String ATTR_VALUE = "value";

    @Nonnull
    public IMicroElement convertToMicroElement(@Nonnull HeightSpec heightSpec, @Nullable String string, @Nonnull String string2) {
        MicroElement microElement = new MicroElement(string, string2);
        microElement.setAttribute(ATTR_TYPE, heightSpec.getTypeID());
        if (heightSpec.isAbsolute()) {
            microElement.setAttribute(ATTR_VALUE, heightSpec.getValue());
        }
        return microElement;
    }

    @Nonnull
    public HeightSpec convertToNative(@Nonnull IMicroElement iMicroElement) {
        String string = iMicroElement.getAttributeValue(ATTR_TYPE);
        EValueUOMType eValueUOMType = EValueUOMType.getFromIDOrNull(string);
        if (eValueUOMType == null) {
            throw new IllegalStateException("Failed to resolve height type with ID '" + string + "!");
        }
        float f = eValueUOMType.isValueRequired() ? iMicroElement.getAttributeValueAsFloat(ATTR_VALUE, Float.NaN) : 0.0f;
        return new HeightSpec(eValueUOMType, f);
    }
}

