/*
 * Decompiled with CFR 0.152.
 */
package com.helger.pdflayout.config.xml;

import com.helger.commons.ValueEnforcer;
import com.helger.pdflayout.base.PLColor;
import com.helger.pdflayout.spec.FontSpec;
import com.helger.pdflayout.spec.IPreloadFontResolver;
import com.helger.pdflayout.spec.PreloadFont;
import com.helger.xml.microdom.IMicroElement;
import com.helger.xml.microdom.IMicroNode;
import com.helger.xml.microdom.MicroElement;
import com.helger.xml.microdom.convert.IMicroTypeConverter;
import com.helger.xml.microdom.convert.MicroTypeConverter;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class FontSpecMicroTypeConverter
implements IMicroTypeConverter<FontSpec> {
    private static final String ATTR_PRELOAD_FONT_ID = "preloadfontid";
    private static final String ATTR_FONT_SIZE = "fontsize";
    private static final String ELEMENT_COLOR = "color";
    private final IPreloadFontResolver m_aPreloadFontResolver;

    public FontSpecMicroTypeConverter(@Nonnull IPreloadFontResolver iPreloadFontResolver) {
        this.m_aPreloadFontResolver = (IPreloadFontResolver)ValueEnforcer.notNull((Object)iPreloadFontResolver, (String)"PreloadFontResolver");
    }

    @Nonnull
    public IMicroElement convertToMicroElement(@Nonnull FontSpec fontSpec, @Nullable String string, @Nonnull String string2) {
        MicroElement microElement = new MicroElement(string, string2);
        microElement.setAttribute(ATTR_PRELOAD_FONT_ID, fontSpec.getPreloadFontID());
        microElement.setAttribute(ATTR_FONT_SIZE, fontSpec.getFontSize());
        PLColor pLColor = fontSpec.getColor();
        if (pLColor != FontSpec.DEFAULT_COLOR) {
            microElement.appendChild((IMicroNode)MicroTypeConverter.convertToMicroElement((Object)pLColor, (String)string, (String)ELEMENT_COLOR));
        }
        return microElement;
    }

    @Nonnull
    public FontSpec convertToNative(@Nonnull IMicroElement iMicroElement) {
        String string = iMicroElement.getAttributeValue(ATTR_PRELOAD_FONT_ID);
        PreloadFont preloadFont = this.m_aPreloadFontResolver.getPreloadFontOfID(string);
        if (preloadFont == null) {
            throw new IllegalStateException("Failed to resolve preloadfont with ID '" + string + "!");
        }
        float f = iMicroElement.getAttributeValueAsFloat(ATTR_FONT_SIZE, Float.NaN);
        PLColor pLColor = (PLColor)MicroTypeConverter.convertToNative((IMicroElement)iMicroElement.getFirstChildElement(ELEMENT_COLOR), PLColor.class, (Object)FontSpec.DEFAULT_COLOR);
        return new FontSpec(preloadFont, f, pLColor);
    }
}

