/*
 * Decompiled with CFR 0.152.
 */
package com.helger.pdflayout.config.xml;

import com.helger.pdflayout.base.PLColor;
import com.helger.pdflayout.spec.BorderStyleSpec;
import com.helger.pdflayout.spec.LineDashPatternSpec;
import com.helger.xml.microdom.IMicroElement;
import com.helger.xml.microdom.IMicroNode;
import com.helger.xml.microdom.MicroElement;
import com.helger.xml.microdom.convert.IMicroTypeConverter;
import com.helger.xml.microdom.convert.MicroTypeConverter;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class BorderStyleSpecMicroTypeConverter
implements IMicroTypeConverter<BorderStyleSpec> {
    private static final String ELEMENT_COLOR = "color";
    private static final String ELEMENT_LINE_DASH_PATTERN = "linedashpattern";
    private static final String ATTR_LINE_WIDTH = "linewidth";

    @Nonnull
    public IMicroElement convertToMicroElement(@Nonnull BorderStyleSpec borderStyleSpec, @Nullable String string, @Nonnull String string2) {
        LineDashPatternSpec lineDashPatternSpec;
        MicroElement microElement = new MicroElement(string, string2);
        PLColor pLColor = borderStyleSpec.getColor();
        if (pLColor != BorderStyleSpec.DEFAULT_COLOR) {
            microElement.appendChild((IMicroNode)MicroTypeConverter.convertToMicroElement((Object)pLColor, (String)string, (String)ELEMENT_COLOR));
        }
        if ((lineDashPatternSpec = borderStyleSpec.getLineDashPattern()) != BorderStyleSpec.DEFAULT_LINE_DASH_PATTERN) {
            microElement.appendChild((IMicroNode)MicroTypeConverter.convertToMicroElement((Object)lineDashPatternSpec, (String)string, (String)ELEMENT_LINE_DASH_PATTERN));
        }
        microElement.setAttribute(ATTR_LINE_WIDTH, borderStyleSpec.getLineWidth());
        return microElement;
    }

    @Nonnull
    public BorderStyleSpec convertToNative(@Nonnull IMicroElement iMicroElement) {
        PLColor pLColor = (PLColor)MicroTypeConverter.convertToNative((IMicroElement)iMicroElement.getFirstChildElement(ELEMENT_COLOR), PLColor.class, (Object)BorderStyleSpec.DEFAULT_COLOR);
        LineDashPatternSpec lineDashPatternSpec = (LineDashPatternSpec)MicroTypeConverter.convertToNative((IMicroElement)iMicroElement.getFirstChildElement(ELEMENT_LINE_DASH_PATTERN), LineDashPatternSpec.class, (Object)BorderStyleSpec.DEFAULT_LINE_DASH_PATTERN);
        float f = iMicroElement.getAttributeValueAsFloat(ATTR_LINE_WIDTH, 1.0f);
        return new BorderStyleSpec(pLColor, lineDashPatternSpec, f);
    }
}

