/*
 * Decompiled with CFR 0.152.
 */
package com.helger.pdflayout.base;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.state.EChange;
import com.helger.commons.state.IChangeIndicator;
import com.helger.commons.string.StringHelper;
import com.helger.commons.string.ToStringGenerator;
import com.helger.pdflayout.base.AbstractPLObject;
import com.helger.pdflayout.base.IPLHasFillColor;
import com.helger.pdflayout.base.IPLHasMarginBorderPadding;
import com.helger.pdflayout.base.IPLRenderableObject;
import com.helger.pdflayout.base.IPLVisitor;
import com.helger.pdflayout.base.PLColor;
import com.helger.pdflayout.base.PLElementWithSize;
import com.helger.pdflayout.base.PLMarginBorderPadding;
import com.helger.pdflayout.base.PLPageSetPrepareResult;
import com.helger.pdflayout.base.PLSplitResult;
import com.helger.pdflayout.debug.PLDebugLog;
import com.helger.pdflayout.element.special.PLPageBreak;
import com.helger.pdflayout.pdfbox.PDPageContentStreamWithCache;
import com.helger.pdflayout.render.ERenderingElementType;
import com.helger.pdflayout.render.IPreRenderContextCustomizer;
import com.helger.pdflayout.render.IRenderContextCustomizer;
import com.helger.pdflayout.render.PLRenderHelper;
import com.helger.pdflayout.render.PagePreRenderContext;
import com.helger.pdflayout.render.PageRenderContext;
import com.helger.pdflayout.render.PreparationContext;
import com.helger.pdflayout.render.PreparationContextGlobal;
import com.helger.pdflayout.spec.BorderSpec;
import com.helger.pdflayout.spec.MarginSpec;
import com.helger.pdflayout.spec.PaddingSpec;
import com.helger.pdflayout.spec.SizeSpec;
import java.io.IOException;
import java.util.Collection;
import java.util.function.Consumer;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public class PLPageSet
extends AbstractPLObject<PLPageSet>
implements IPLHasMarginBorderPadding<PLPageSet>,
IPLHasFillColor<PLPageSet> {
    public static final boolean DEFAULT_DIFFERENT_FIRST_PAGE_HEADER = false;
    public static final boolean DEFAULT_DIFFERENT_FIRST_PAGE_FOOTER = false;
    private static final Logger LOGGER = LoggerFactory.getLogger(PLPageSet.class);
    private final SizeSpec m_aPageSize;
    private MarginSpec m_aMargin = DEFAULT_MARGIN;
    private PaddingSpec m_aPadding = DEFAULT_PADDING;
    private BorderSpec m_aBorder = DEFAULT_BORDER;
    private PLColor m_aFillColor = DEFAULT_FILL_COLOR;
    private boolean m_bDifferentFirstPageHeader = false;
    private IPLRenderableObject<?> m_aFirstPageHeader;
    private IPLRenderableObject<?> m_aPageHeader;
    private final ICommonsList<IPLRenderableObject<?>> m_aElements = new CommonsArrayList();
    private boolean m_bDifferentFirstPageFooter = false;
    private IPLRenderableObject<?> m_aFirstPageFooter;
    private IPLRenderableObject<?> m_aPageFooter;
    private IPreRenderContextCustomizer m_aPRCCustomizer;
    private IRenderContextCustomizer m_aRCCustomizer;

    public PLPageSet(@Nonnull PDRectangle pDRectangle) {
        this(SizeSpec.create(pDRectangle));
    }

    public PLPageSet(@Nonnegative float f, @Nonnegative float f2) {
        this(new SizeSpec(f, f2));
    }

    public PLPageSet(@Nonnull SizeSpec sizeSpec) {
        this.m_aPageSize = (SizeSpec)ValueEnforcer.notNull((Object)sizeSpec, (String)"PageSize");
    }

    @Nonnull
    public final SizeSpec getPageSize() {
        return this.m_aPageSize;
    }

    public final float getPageWidth() {
        return this.m_aPageSize.getWidth();
    }

    public final float getPageHeight() {
        return this.m_aPageSize.getHeight();
    }

    @Override
    @Nonnull
    public final MarginSpec getMargin() {
        return this.m_aMargin;
    }

    @Override
    @Nonnull
    public final PLPageSet setMargin(@Nonnull MarginSpec marginSpec) {
        ValueEnforcer.notNull((Object)marginSpec, (String)"Mergin");
        this.m_aMargin = marginSpec;
        return this;
    }

    @Override
    @Nonnull
    public final PaddingSpec getPadding() {
        return this.m_aPadding;
    }

    @Override
    @Nonnull
    public final PLPageSet setPadding(@Nonnull PaddingSpec paddingSpec) {
        ValueEnforcer.notNull((Object)paddingSpec, (String)"Padding");
        this.m_aPadding = paddingSpec;
        return this;
    }

    @Override
    @Nonnull
    public final BorderSpec getBorder() {
        return this.m_aBorder;
    }

    @Override
    @Nonnull
    public final PLPageSet setBorder(@Nonnull BorderSpec borderSpec) {
        ValueEnforcer.notNull((Object)borderSpec, (String)"Border");
        this.m_aBorder = borderSpec;
        return this;
    }

    @Override
    @Nullable
    public final PLColor getFillColor() {
        return this.m_aFillColor;
    }

    @Override
    @Nonnull
    public final PLPageSet setFillColor(@Nullable PLColor pLColor) {
        this.m_aFillColor = pLColor;
        return this;
    }

    @Nullable
    public final IPreRenderContextCustomizer getPreRenderContextCustomizer() {
        return this.m_aPRCCustomizer;
    }

    @Nonnull
    public final PLPageSet setPreRenderContextCustomizer(@Nullable IPreRenderContextCustomizer iPreRenderContextCustomizer) {
        this.m_aPRCCustomizer = iPreRenderContextCustomizer;
        return this;
    }

    @Nullable
    public final IRenderContextCustomizer getRenderContextCustomizer() {
        return this.m_aRCCustomizer;
    }

    @Nonnull
    public final PLPageSet setRenderContextCustomizer(@Nullable IRenderContextCustomizer iRenderContextCustomizer) {
        this.m_aRCCustomizer = iRenderContextCustomizer;
        return this;
    }

    @Nonnegative
    private float _getAvailableWidth(@Nonnull IPLHasMarginBorderPadding<?> iPLHasMarginBorderPadding) {
        return this.m_aPageSize.getWidth() - iPLHasMarginBorderPadding.getOutlineXSum();
    }

    @Nonnegative
    public float getAvailableWidth() {
        return this._getAvailableWidth(this);
    }

    @Nonnegative
    private float _getAvailableHeight(@Nonnull IPLHasMarginBorderPadding<?> iPLHasMarginBorderPadding) {
        return this.m_aPageSize.getHeight() - iPLHasMarginBorderPadding.getOutlineYSum();
    }

    @Nonnegative
    public float getAvailableHeight() {
        return this._getAvailableHeight(this);
    }

    public boolean isDifferentFirstPageHeader() {
        return this.m_bDifferentFirstPageHeader;
    }

    @Nonnull
    public PLPageSet setDifferentFirstPageHeader(boolean bl) {
        this.m_bDifferentFirstPageHeader = bl;
        return this;
    }

    @Nullable
    public IPLRenderableObject<?> getFirstPageHeader() {
        return this.m_aFirstPageHeader;
    }

    public boolean hasFirstPageHeader() {
        return this.m_aFirstPageHeader != null;
    }

    @Nonnull
    public PLPageSet setFirstPageHeader(@Nullable IPLRenderableObject<?> iPLRenderableObject) {
        this.m_aFirstPageHeader = iPLRenderableObject;
        return this;
    }

    @Nullable
    public IPLRenderableObject<?> getPageHeader() {
        return this.m_aPageHeader;
    }

    public boolean hasPageHeader() {
        return this.m_aPageHeader != null;
    }

    @Nonnull
    public PLPageSet setPageHeader(@Nullable IPLRenderableObject<?> iPLRenderableObject) {
        this.m_aPageHeader = iPLRenderableObject;
        return this;
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<? extends IPLRenderableObject<?>> getAllElements() {
        return (ICommonsList)this.m_aElements.getClone();
    }

    @Nonnegative
    public int getElementCount() {
        return this.m_aElements.size();
    }

    public void forEachElement(@Nonnull Consumer<? super IPLRenderableObject<?>> consumer) {
        this.m_aElements.forEach(consumer);
    }

    @Nonnull
    public PLPageSet addElement(@Nonnull IPLRenderableObject<?> iPLRenderableObject) {
        ValueEnforcer.notNull(iPLRenderableObject, (String)"Element");
        this.m_aElements.add(iPLRenderableObject);
        return this;
    }

    public boolean isDifferentFirstPageFooter() {
        return this.m_bDifferentFirstPageFooter;
    }

    @Nonnull
    public PLPageSet setDifferentFirstPageFooter(boolean bl) {
        this.m_bDifferentFirstPageFooter = bl;
        return this;
    }

    @Nullable
    public IPLRenderableObject<?> getFirstPageFooter() {
        return this.m_aFirstPageFooter;
    }

    public boolean hasFirstPageFooter() {
        return this.m_aFirstPageFooter != null;
    }

    @Nonnull
    public PLPageSet setFirstPageFooter(@Nullable IPLRenderableObject<?> iPLRenderableObject) {
        this.m_aFirstPageFooter = iPLRenderableObject;
        return this;
    }

    @Nullable
    public IPLRenderableObject<?> getPageFooter() {
        return this.m_aPageFooter;
    }

    public boolean hasPageFooter() {
        return this.m_aPageFooter != null;
    }

    @Nonnull
    public PLPageSet setPageFooter(@Nullable IPLRenderableObject<?> iPLRenderableObject) {
        this.m_aPageFooter = iPLRenderableObject;
        return this;
    }

    private float _getYTop(@Nonnull IPLHasMarginBorderPadding<?> iPLHasMarginBorderPadding) {
        return this.m_aPageSize.getHeight() - iPLHasMarginBorderPadding.getOutlineTop();
    }

    public float getYTop() {
        return this._getYTop(this);
    }

    @Override
    @Nonnull
    public EChange visit(@Nonnull IPLVisitor iPLVisitor) throws IOException {
        EChange eChange = EChange.UNCHANGED;
        iPLVisitor.onPageSetStart(this);
        if (this.m_bDifferentFirstPageHeader && this.m_aFirstPageHeader != null) {
            eChange = eChange.or((IChangeIndicator)this.m_aFirstPageHeader.visit(iPLVisitor));
        }
        if (this.m_aPageHeader != null) {
            eChange = eChange.or((IChangeIndicator)this.m_aPageHeader.visit(iPLVisitor));
        }
        if (this.m_bDifferentFirstPageFooter && this.m_aFirstPageFooter != null) {
            eChange = eChange.or((IChangeIndicator)this.m_aFirstPageFooter.visit(iPLVisitor));
        }
        if (this.m_aPageFooter != null) {
            eChange = eChange.or((IChangeIndicator)this.m_aPageFooter.visit(iPLVisitor));
        }
        for (IPLRenderableObject iPLRenderableObject : this.m_aElements) {
            eChange = eChange.or((IChangeIndicator)iPLRenderableObject.visit(iPLVisitor));
        }
        iPLVisitor.onPageSetEnd(this);
        return eChange;
    }

    @Nonnull
    public PLPageSetPrepareResult prepareAllPages(@Nonnull PreparationContextGlobal preparationContextGlobal) {
        IPLRenderableObject<?> iPLRenderableObject;
        Object object2;
        float f;
        SizeSpec sizeSpec;
        PreparationContext preparationContext;
        PLPageSetPrepareResult pLPageSetPrepareResult = new PLPageSetPrepareResult();
        PLMarginBorderPadding pLMarginBorderPadding = new PLMarginBorderPadding(this.m_aMargin, this.m_aPadding, this.m_aBorder);
        if (this.m_bDifferentFirstPageHeader && this.m_aFirstPageHeader != null) {
            preparationContext = new PreparationContext(preparationContextGlobal, this.m_aPageSize.getWidth() - pLMarginBorderPadding.getMarginXSum(), pLMarginBorderPadding.getMarginTop());
            if (PLDebugLog.isDebugPrepare()) {
                PLDebugLog.debugPrepare(this, "Start preparing first page header on width=" + preparationContext.getAvailableWidth() + " and height=" + preparationContext.getAvailableHeight());
            }
            sizeSpec = this.m_aFirstPageHeader.prepare(preparationContext);
            pLPageSetPrepareResult.setFirstHeaderHeight(sizeSpec.getHeight());
            f = sizeSpec.getHeight() + this.m_aFirstPageHeader.getOutlineYSum();
            if (f > pLMarginBorderPadding.getMarginTop()) {
                LOGGER.info("PageSet margin top was changed from " + pLMarginBorderPadding.getMarginTop() + " to " + f + " so that firstPageHeader fits!");
                pLMarginBorderPadding.setMarginTop(f);
            }
        }
        if (this.m_aPageHeader != null) {
            preparationContext = new PreparationContext(preparationContextGlobal, this.m_aPageSize.getWidth() - this.getMarginXSum(), this.getMarginTop());
            if (PLDebugLog.isDebugPrepare()) {
                PLDebugLog.debugPrepare(this, "Start preparing page header on width=" + preparationContext.getAvailableWidth() + " and height=" + preparationContext.getAvailableHeight());
            }
            sizeSpec = this.m_aPageHeader.prepare(preparationContext);
            pLPageSetPrepareResult.setHeaderHeight(sizeSpec.getHeight());
            f = sizeSpec.getHeight() + this.m_aPageHeader.getOutlineYSum();
            if (f > this.getMarginTop()) {
                LOGGER.info("PageSet margin top was changed from " + this.getMarginTop() + " to " + f + " so that pageHeader fits!");
                this.setMarginTop(f);
            }
        }
        if (this.m_bDifferentFirstPageFooter && this.m_aFirstPageFooter != null) {
            preparationContext = new PreparationContext(preparationContextGlobal, this.m_aPageSize.getWidth() - pLMarginBorderPadding.getMarginXSum(), pLMarginBorderPadding.getMarginBottom());
            if (PLDebugLog.isDebugPrepare()) {
                PLDebugLog.debugPrepare(this, "Start preparing first page footer on width=" + preparationContext.getAvailableWidth() + " and height=" + preparationContext.getAvailableHeight());
            }
            sizeSpec = this.m_aFirstPageFooter.prepare(preparationContext);
            pLPageSetPrepareResult.setFirstFooterHeight(sizeSpec.getHeight());
            f = sizeSpec.getHeight() + this.m_aFirstPageFooter.getOutlineYSum();
            if (f > pLMarginBorderPadding.getMarginBottom()) {
                LOGGER.info("PageSet margin bottom was changed from " + pLMarginBorderPadding.getMarginBottom() + " to " + f + " so that firstPageFooter fits!");
                pLMarginBorderPadding.setMarginBottom(f);
            }
        }
        if (this.m_aPageFooter != null) {
            preparationContext = new PreparationContext(preparationContextGlobal, this.m_aPageSize.getWidth() - this.getMarginXSum(), this.getMarginBottom());
            if (PLDebugLog.isDebugPrepare()) {
                PLDebugLog.debugPrepare(this, "Start preparing page footer on width=" + preparationContext.getAvailableWidth() + " and height=" + preparationContext.getAvailableHeight());
            }
            sizeSpec = this.m_aPageFooter.prepare(preparationContext);
            pLPageSetPrepareResult.setFooterHeight(sizeSpec.getHeight());
            f = sizeSpec.getHeight() + this.m_aPageFooter.getOutlineYSum();
            if (f > this.getMarginBottom()) {
                LOGGER.info("PageSet margin bottom was changed from " + this.getMarginBottom() + " to " + f + " so that pageFooter fits!");
                this.setMarginBottom(f);
            }
        }
        if (pLMarginBorderPadding.getMarginYSum() > this.m_aPageSize.getHeight()) {
            throw new IllegalStateException("First page header and footer together (" + pLMarginBorderPadding.getMarginYSum() + ") take more height than available on the page (" + this.m_aPageSize.getHeight() + ")! Cannot render!");
        }
        if (this.getMarginYSum() > this.m_aPageSize.getHeight()) {
            throw new IllegalStateException("Header and footer together (" + this.getMarginYSum() + ") take more height than available on the page (" + this.m_aPageSize.getHeight() + ")! Cannot render!");
        }
        pLPageSetPrepareResult.setFirstPageMBP(pLMarginBorderPadding);
        float f2 = Math.min(this._getAvailableWidth(pLMarginBorderPadding), this._getAvailableWidth(this));
        float f3 = Math.min(this._getAvailableHeight(pLMarginBorderPadding), this._getAvailableHeight(this));
        if (PLDebugLog.isDebugPrepare()) {
            PLDebugLog.debugPrepare(this, "Start preparing elements on width=" + f2 + "+" + this.getOutlineXSum() + " and height=" + f3 + "+" + this.getOutlineYSum());
        }
        for (Object object2 : this.m_aElements) {
            iPLRenderableObject = new PreparationContext(preparationContextGlobal, f2, f3);
            SizeSpec sizeSpec2 = object2.prepare((PreparationContext)((Object)iPLRenderableObject));
            pLPageSetPrepareResult.addElement(new PLElementWithSize((IPLRenderableObject<?>)object2, sizeSpec2));
        }
        if (PLDebugLog.isDebugPrepare()) {
            PLDebugLog.debugPrepare(this, "Finished preparing elements");
        }
        if (PLDebugLog.isDebugSplit()) {
            PLDebugLog.debugSplit(this, "Start splitting elements");
        }
        CommonsArrayList commonsArrayList = new CommonsArrayList();
        f3 = this._getYTop(pLMarginBorderPadding);
        ICommonsList<PLElementWithSize> iCommonsList = pLPageSetPrepareResult.getAllElements();
        while (iCommonsList.isNotEmpty()) {
            object2 = (PLElementWithSize)iCommonsList.remove(0);
            iPLRenderableObject = ((PLElementWithSize)object2).getElement();
            boolean bl = iPLRenderableObject instanceof PLPageBreak;
            if (bl && commonsArrayList.isEmpty() && !((PLPageBreak)iPLRenderableObject).isForcePageBreak()) {
                bl = false;
            }
            float f4 = ((PLElementWithSize)object2).getWidth();
            float f5 = ((PLElementWithSize)object2).getHeightFull();
            float f6 = (pLPageSetPrepareResult.getPageCount() == 0 ? pLMarginBorderPadding : this).getOutlineBottom();
            float f7 = f3 - f6;
            if (f3 - f5 < f6 || bl) {
                float f8;
                boolean bl2 = iPLRenderableObject.isVertSplittable();
                if (bl2 && (f8 = f7 - iPLRenderableObject.getOutlineYSum()) > 0.0f) {
                    PLSplitResult pLSplitResult;
                    if (PLDebugLog.isDebugSplit()) {
                        PLDebugLog.debugSplit(this, "Trying to split " + iPLRenderableObject.getDebugID() + " into pieces for available width " + f4 + " and height " + f8);
                    }
                    if ((pLSplitResult = iPLRenderableObject.getAsSplittable().splitElementVert(f4, f8)) != null) assert (f8 > 0.0f);
                    if (f8 <= 0.0f) assert (pLSplitResult == null);
                    if (pLSplitResult != null) {
                        iCommonsList.add(0, (Object)pLSplitResult.getFirstElement());
                        iCommonsList.add(1, (Object)pLSplitResult.getSecondElement());
                        if (!PLDebugLog.isDebugSplit()) continue;
                        PLDebugLog.debugSplit(this, "Split " + iPLRenderableObject.getDebugID() + " into pieces: " + pLSplitResult.getFirstElement().getElement().getDebugID() + " (" + pLSplitResult.getFirstElement().getWidth() + "+" + pLSplitResult.getFirstElement().getElement().getOutlineXSum() + " & " + pLSplitResult.getFirstElement().getHeight() + "+" + pLSplitResult.getFirstElement().getElement().getOutlineYSum() + ") and " + pLSplitResult.getSecondElement().getElement().getDebugID() + " (" + pLSplitResult.getSecondElement().getWidth() + "+" + pLSplitResult.getSecondElement().getElement().getOutlineXSum() + " & " + pLSplitResult.getSecondElement().getHeight() + "+" + pLSplitResult.getSecondElement().getElement().getOutlineYSum() + ")");
                        continue;
                    }
                    if (PLDebugLog.isDebugSplit()) {
                        PLDebugLog.debugSplit(this, "The single element " + iPLRenderableObject.getDebugID() + " does not fit onto a single page (" + f8 + ") even though it is vertically splittable!");
                    }
                }
                if (commonsArrayList.isEmpty()) {
                    if (!bl) {
                        LOGGER.warn("The single element " + iPLRenderableObject.getDebugID() + " does not fit onto a single page" + (bl2 ? " even though it is vertically splittable!" : " and is not vertically splittable!"));
                    }
                } else {
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("Adding " + commonsArrayList.size() + " elements to page " + pLPageSetPrepareResult.getPageNumber());
                    }
                    if (PLDebugLog.isDebugPrepare()) {
                        CommonsArrayList commonsArrayList2 = new CommonsArrayList((Collection)commonsArrayList, pLElementWithSize -> pLElementWithSize.getElement().getDebugID());
                        PLDebugLog.debugPrepare(this, "Finished page " + pLPageSetPrepareResult.getPageNumber() + " with: " + StringHelper.getImploded((Iterable)commonsArrayList2));
                    }
                    pLPageSetPrepareResult.addPerPageElements((ICommonsList<PLElementWithSize>)commonsArrayList);
                    commonsArrayList = new CommonsArrayList();
                    iCommonsList.add(0, object2);
                    f3 = this._getYTop(this);
                    continue;
                }
            }
            commonsArrayList.add(object2);
            f3 -= f5;
        }
        if (commonsArrayList.isNotEmpty()) {
            if (PLDebugLog.isDebugSplit()) {
                object2 = new CommonsArrayList((Collection)commonsArrayList, pLElementWithSize -> pLElementWithSize.getElement().getDebugID());
                PLDebugLog.debugSplit(this, "Finished last page " + pLPageSetPrepareResult.getPageNumber() + " with: " + StringHelper.getImploded((String)", ", (Iterable)object2));
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Adding " + commonsArrayList.size() + " elements to page " + pLPageSetPrepareResult.getPageNumber());
            }
            pLPageSetPrepareResult.addPerPageElements((ICommonsList<PLElementWithSize>)commonsArrayList);
        }
        if (PLDebugLog.isDebugSplit()) {
            PLDebugLog.debugSplit(this, "Finished splitting elements");
        }
        return pLPageSetPrepareResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void renderAllPages(@Nonnull PLPageSetPrepareResult pLPageSetPrepareResult, @Nonnull PDDocument pDDocument, boolean bl, @Nonnegative int n, @Nonnegative int n2, @Nonnegative int n3, @Nonnegative int n4) throws IOException {
        float f = this.getOutlineLeft();
        int n5 = 0;
        int n6 = pLPageSetPrepareResult.getPageCount();
        for (ICommonsList iCommonsList : pLPageSetPrepareResult.directGetPerPageElements()) {
            IPLHasMarginBorderPadding<PLPageSet> iPLHasMarginBorderPadding;
            boolean bl2 = n5 == 0;
            IPLHasMarginBorderPadding<PLPageSet> iPLHasMarginBorderPadding2 = iPLHasMarginBorderPadding = bl2 ? pLPageSetPrepareResult.getFirstPageMBP() : this;
            if (PLDebugLog.isDebugRender()) {
                PLDebugLog.debugRender(this, "Start rendering page index " + n5 + " (" + (n3 + n5) + ") with page size " + PLDebugLog.getWH(this.getPageWidth(), this.getPageHeight()) + " and available size " + PLDebugLog.getWH(this._getAvailableWidth(iPLHasMarginBorderPadding), this._getAvailableHeight(iPLHasMarginBorderPadding)));
            }
            PDPage pDPage = new PDPage(this.m_aPageSize.getAsRectangle());
            pDDocument.addPage(pDPage);
            IPLRenderableObject<?> iPLRenderableObject = bl2 && this.m_bDifferentFirstPageHeader ? this.m_aFirstPageHeader : this.m_aPageHeader;
            IPLRenderableObject<?> iPLRenderableObject2 = bl2 && this.m_bDifferentFirstPageFooter ? this.m_aFirstPageFooter : this.m_aPageFooter;
            Object object = new PagePreRenderContext(this, pDDocument, pDPage, n, n2, n5, n6, n3 + n5, n4);
            if (this.m_aPRCCustomizer != null) {
                this.m_aPRCCustomizer.customizePreRenderContext((PagePreRenderContext)object);
            }
            IPLVisitor iPLVisitor = IPLVisitor.createElementVisitor(arg_0 -> PLPageSet.lambda$renderAllPages$2((PagePreRenderContext)object, arg_0));
            if (iPLRenderableObject != null) {
                iPLRenderableObject.visit(iPLVisitor);
            }
            if (iPLRenderableObject2 != null) {
                iPLRenderableObject2.visit(iPLVisitor);
            }
            for (PLElementWithSize pLElementWithSize : iCommonsList) {
                pLElementWithSize.getElement().visit(iPLVisitor);
            }
            object = new PDPageContentStreamWithCache(pDDocument, pDPage, PDPageContentStream.AppendMode.OVERWRITE, bl);
            try {
                float f2 = 0.0f + iPLHasMarginBorderPadding.getMarginLeft();
                float f3 = this.m_aPageSize.getHeight() - iPLHasMarginBorderPadding.getMarginTop();
                float f4 = this.m_aPageSize.getWidth() - iPLHasMarginBorderPadding.getMarginXSum();
                float f5 = this.m_aPageSize.getHeight() - iPLHasMarginBorderPadding.getMarginYSum();
                PLRenderHelper.fillAndRenderBorder(this, f2, f3, f4, f5, (PDPageContentStreamWithCache)object);
                if (iPLRenderableObject != null) {
                    f2 = iPLHasMarginBorderPadding.getMarginLeft();
                    f3 = this.m_aPageSize.getHeight();
                    f4 = this.m_aPageSize.getWidth() - iPLHasMarginBorderPadding.getMarginXSum();
                    f5 = pLPageSetPrepareResult.getHeaderHeight(n5);
                    PageRenderContext pageRenderContext = new PageRenderContext(ERenderingElementType.PAGE_HEADER, (PDPageContentStreamWithCache)object, f2, f3, f4, f5);
                    if (this.m_aRCCustomizer != null) {
                        this.m_aRCCustomizer.customizeRenderContext(pageRenderContext);
                    }
                    iPLRenderableObject.render(pageRenderContext);
                }
                f2 = this._getYTop(iPLHasMarginBorderPadding);
                for (PLElementWithSize pLElementWithSize : iCommonsList) {
                    IPLRenderableObject<?> iPLRenderableObject3 = pLElementWithSize.getElement();
                    float f6 = f;
                    float f7 = f2;
                    float f8 = this._getAvailableWidth(iPLHasMarginBorderPadding);
                    float f9 = pLElementWithSize.getHeightFull();
                    PageRenderContext pageRenderContext = new PageRenderContext(ERenderingElementType.CONTENT_ELEMENT, (PDPageContentStreamWithCache)object, f6, f7, f8, f9);
                    if (this.m_aRCCustomizer != null) {
                        this.m_aRCCustomizer.customizeRenderContext(pageRenderContext);
                    }
                    iPLRenderableObject3.render(pageRenderContext);
                    f2 -= pLElementWithSize.getHeightFull();
                }
                if (iPLRenderableObject2 != null) {
                    float f10 = iPLHasMarginBorderPadding.getMarginLeft();
                    float f11 = iPLHasMarginBorderPadding.getMarginBottom();
                    f5 = this.m_aPageSize.getWidth() - iPLHasMarginBorderPadding.getMarginXSum();
                    float f12 = pLPageSetPrepareResult.getFooterHeight(n5);
                    PageRenderContext pageRenderContext = new PageRenderContext(ERenderingElementType.PAGE_FOOTER, (PDPageContentStreamWithCache)object, f10, f11, f5, f12);
                    if (this.m_aRCCustomizer != null) {
                        this.m_aRCCustomizer.customizeRenderContext(pageRenderContext);
                    }
                    iPLRenderableObject2.render(pageRenderContext);
                }
            }
            finally {
                ((PDPageContentStreamWithCache)object).close();
            }
            ++n5;
        }
        if (PLDebugLog.isDebugRender()) {
            PLDebugLog.debugRender(this, "Finished rendering");
        }
    }

    @Override
    public String toString() {
        return ToStringGenerator.getDerived((String)super.toString()).append("PageSize", (Object)this.m_aPageSize).append("Margin", (Object)this.m_aMargin).append("Padding", (Object)this.m_aPadding).append("Border", (Object)this.m_aBorder).append("FillColor", (Object)this.m_aFillColor).appendIfNotNull("FirstPageHeader", this.m_aFirstPageHeader).appendIfNotNull("PageHeader", this.m_aPageHeader).append("Elements", this.m_aElements).appendIfNotNull("FirstPageFooter", this.m_aFirstPageFooter).appendIfNotNull("PageFooter", this.m_aPageFooter).appendIfNotNull("PRCCustomizer", (Object)this.m_aPRCCustomizer).appendIfNotNull("RCCustomizer", (Object)this.m_aRCCustomizer).getToString();
    }

    private static /* synthetic */ EChange lambda$renderAllPages$2(PagePreRenderContext pagePreRenderContext, IPLRenderableObject iPLRenderableObject) throws IOException {
        return iPLRenderableObject.beforeRender(pagePreRenderContext);
    }
}

