/*
 * Decompiled with CFR 0.152.
 */
package com.helger.pdflayout.base;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.string.ToStringGenerator;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;
import org.apache.pdfbox.pdmodel.graphics.color.PDColor;
import org.apache.pdfbox.pdmodel.graphics.color.PDColorSpace;
import org.apache.pdfbox.pdmodel.graphics.color.PDDeviceRGB;

@Immutable
public class PLColor {
    public static final PLColor WHITE = new PLColor(255, 255, 255);
    public static final PLColor LIGHT_GRAY = new PLColor(192, 192, 192);
    public static final PLColor GRAY = new PLColor(128, 128, 128);
    public static final PLColor DARK_GRAY = new PLColor(64, 64, 64);
    public static final PLColor BLACK = new PLColor(0, 0, 0);
    public static final PLColor RED = new PLColor(255, 0, 0);
    public static final PLColor PINK = new PLColor(255, 175, 175);
    public static final PLColor ORANGE = new PLColor(255, 200, 0);
    public static final PLColor YELLOW = new PLColor(255, 255, 0);
    public static final PLColor GREEN = new PLColor(0, 255, 0);
    public static final PLColor MAGENTA = new PLColor(255, 0, 255);
    public static final PLColor CYAN = new PLColor(0, 255, 255);
    public static final PLColor BLUE = new PLColor(0, 0, 255);
    private final int m_nRed;
    private final int m_nGreen;
    private final int m_nBlue;

    public PLColor(int n, int n2, int n3) {
        ValueEnforcer.isBetweenInclusive((int)n, (String)"red", (int)0, (int)255);
        ValueEnforcer.isBetweenInclusive((int)n2, (String)"green", (int)0, (int)255);
        ValueEnforcer.isBetweenInclusive((int)n3, (String)"blue", (int)0, (int)255);
        this.m_nRed = n;
        this.m_nGreen = n2;
        this.m_nBlue = n3;
    }

    public int getRed() {
        return this.m_nRed;
    }

    public int getGreen() {
        return this.m_nGreen;
    }

    public int getBlue() {
        return this.m_nBlue;
    }

    @Nonnull
    public PDColor getAsPDColor() {
        float[] fArray = new float[]{(float)this.m_nRed / 255.0f, (float)this.m_nGreen / 255.0f, (float)this.m_nBlue / 255.0f};
        return new PDColor(fArray, (PDColorSpace)PDDeviceRGB.INSTANCE);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        PLColor pLColor = (PLColor)object;
        return this.m_nRed == pLColor.m_nRed && this.m_nGreen == pLColor.m_nGreen && this.m_nBlue == pLColor.m_nBlue;
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append(this.m_nRed).append(this.m_nGreen).append(this.m_nBlue).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(null).append("Red", this.m_nRed).append("Green", this.m_nGreen).append("Blue", this.m_nBlue).getToString();
    }

    @Nonnull
    public static PLColor gray(int n) {
        return new PLColor(n, n, n);
    }
}

