/*
 * Decompiled with CFR 0.152.
 */
package com.helger.pdflayout.base;

import com.helger.commons.traits.IGenericImplTrait;
import com.helger.pdflayout.base.IPLHasOutline;
import com.helger.pdflayout.spec.MarginSpec;
import javax.annotation.Nonnull;

public interface IPLHasMargin<IMPLTYPE extends IPLHasMargin<IMPLTYPE>>
extends IPLHasOutline,
IGenericImplTrait<IMPLTYPE> {
    public static final MarginSpec DEFAULT_MARGIN = MarginSpec.MARGIN0;

    @Nonnull
    default public IMPLTYPE setMargin(float f) {
        return this.setMargin(f, f);
    }

    @Nonnull
    default public IMPLTYPE setMargin(float f, float f2) {
        return this.setMargin(f, f2, f, f2);
    }

    @Nonnull
    default public IMPLTYPE setMargin(float f, float f2, float f3, float f4) {
        return this.setMargin(new MarginSpec(f, f2, f3, f4));
    }

    @Nonnull
    public IMPLTYPE setMargin(@Nonnull MarginSpec var1);

    @Nonnull
    default public IMPLTYPE setMarginTop(float f) {
        return this.setMargin(this.getMargin().getCloneWithTop(f));
    }

    @Nonnull
    default public IMPLTYPE setMarginRight(float f) {
        return this.setMargin(this.getMargin().getCloneWithRight(f));
    }

    @Nonnull
    default public IMPLTYPE setMarginBottom(float f) {
        return this.setMargin(this.getMargin().getCloneWithBottom(f));
    }

    @Nonnull
    default public IMPLTYPE setMarginLeft(float f) {
        return this.setMargin(this.getMargin().getCloneWithLeft(f));
    }

    @Nonnull
    default public IMPLTYPE setMarginX(float f) {
        return this.setMarginLeft(f).setMarginRight(f);
    }

    @Nonnull
    default public IMPLTYPE setMarginY(float f) {
        return this.setMarginTop(f).setMarginBottom(f);
    }

    @Nonnull
    default public IMPLTYPE addMarginTop(float f) {
        if (f == 0.0f) {
            return (IMPLTYPE)((IPLHasMargin)this.thisAsT());
        }
        return this.setMarginTop(this.getMarginTop() + f);
    }

    @Nonnull
    default public IMPLTYPE addMarginRight(float f) {
        if (f == 0.0f) {
            return (IMPLTYPE)((IPLHasMargin)this.thisAsT());
        }
        return this.setMarginRight(this.getMarginRight() + f);
    }

    @Nonnull
    default public IMPLTYPE addMarginBottom(float f) {
        if (f == 0.0f) {
            return (IMPLTYPE)((IPLHasMargin)this.thisAsT());
        }
        return this.setMarginBottom(this.getMarginBottom() + f);
    }

    @Nonnull
    default public IMPLTYPE addMarginLeft(float f) {
        if (f == 0.0f) {
            return (IMPLTYPE)((IPLHasMargin)this.thisAsT());
        }
        return this.setMarginLeft(this.getMarginLeft() + f);
    }

    @Nonnull
    default public IMPLTYPE addMarginX(float f) {
        return this.addMarginLeft(f).addMarginRight(f);
    }

    @Nonnull
    default public IMPLTYPE addMarginY(float f) {
        return this.addMarginTop(f).addMarginBottom(f);
    }

    @Nonnull
    public MarginSpec getMargin();

    default public float getMarginTop() {
        return this.getMargin().getTop();
    }

    default public float getMarginRight() {
        return this.getMargin().getRight();
    }

    default public float getMarginBottom() {
        return this.getMargin().getBottom();
    }

    default public float getMarginLeft() {
        return this.getMargin().getLeft();
    }

    default public float getMarginXSum() {
        return this.getMargin().getXSum();
    }

    default public float getMarginYSum() {
        return this.getMargin().getYSum();
    }

    @Override
    default public float getOutlineTop() {
        return this.getMarginTop();
    }

    @Override
    default public float getOutlineRight() {
        return this.getMarginRight();
    }

    @Override
    default public float getOutlineBottom() {
        return this.getMarginBottom();
    }

    @Override
    default public float getOutlineLeft() {
        return this.getMarginLeft();
    }

    @Override
    default public float getOutlineXSum() {
        return this.getMarginXSum();
    }

    @Override
    default public float getOutlineYSum() {
        return this.getMarginYSum();
    }
}

