/*
 * Decompiled with CFR 0.152.
 */
package com.helger.pdflayout.base;

import com.helger.pdflayout.base.IPLHasFillColor;
import com.helger.pdflayout.base.IPLHasMarginBorderPadding;
import com.helger.pdflayout.base.IPLRenderableObject;
import com.helger.pdflayout.spec.SizeSpec;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;

public interface IPLElement<IMPLTYPE extends IPLElement<IMPLTYPE>>
extends IPLRenderableObject<IMPLTYPE>,
IPLHasMarginBorderPadding<IMPLTYPE>,
IPLHasFillColor<IMPLTYPE> {
    public static final SizeSpec DEFAULT_MIN_SIZE = SizeSpec.SIZE0;
    public static final SizeSpec DEFAULT_MAX_SIZE = SizeSpec.SIZE_MAX;

    @Nonnull
    public SizeSpec getMinSize();

    default public float getMinWidth() {
        return this.getMinSize().getWidth();
    }

    default public float getMinHeight() {
        return this.getMinSize().getHeight();
    }

    @Nonnull
    default public IMPLTYPE setMinSize(@Nonnegative float f, @Nonnegative float f2) {
        return this.setMinSize(new SizeSpec(f, f2));
    }

    @Nonnull
    public IMPLTYPE setMinSize(@Nonnull SizeSpec var1);

    @Nonnull
    default public IMPLTYPE setMinWidth(@Nonnegative float f) {
        return this.setMinSize(f, this.getMinHeight());
    }

    @Nonnull
    default public IMPLTYPE setMinHeight(@Nonnegative float f) {
        return this.setMinSize(this.getMinWidth(), f);
    }

    @Nonnull
    public SizeSpec getMaxSize();

    default public float getMaxWidth() {
        return this.getMaxSize().getWidth();
    }

    default public float getMaxHeight() {
        return this.getMaxSize().getHeight();
    }

    @Nonnull
    default public IMPLTYPE setMaxSize(@Nonnegative float f, @Nonnegative float f2) {
        return this.setMaxSize(new SizeSpec(f, f2));
    }

    @Nonnull
    public IMPLTYPE setMaxSize(@Nonnull SizeSpec var1);

    @Nonnull
    default public IMPLTYPE setMaxWidth(@Nonnegative float f) {
        return this.setMaxSize(f, this.getMaxHeight());
    }

    @Nonnull
    default public IMPLTYPE setMaxHeight(@Nonnegative float f) {
        return this.setMaxSize(this.getMaxWidth(), f);
    }

    @Nonnull
    default public IMPLTYPE setExactSize(@Nonnegative float f, @Nonnegative float f2) {
        this.setMinSize(f, f2);
        return this.setMaxSize(f, f2);
    }

    @Nonnull
    default public IMPLTYPE setExactWidth(@Nonnegative float f) {
        this.setMinWidth(f);
        return this.setMaxWidth(f);
    }

    @Nonnull
    default public IMPLTYPE setExactHeight(@Nonnegative float f) {
        this.setMinHeight(f);
        return this.setMaxHeight(f);
    }
}

