/*
 * Decompiled with CFR 0.152.
 */
package com.helger.pdflayout;

import javax.annotation.Nonnegative;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class PLConvert {
    public static final int DEFAULT_USER_SPACE_UNIT_DPI = 72;
    private static final PLConvert INSTANCE = new PLConvert();

    private PLConvert() {
    }

    public static float mm2units(float f) {
        return PLConvert.mm2units(f, 72);
    }

    public static float mm2units(float f, @Nonnegative int n) {
        return f * (float)n / 25.4f;
    }

    public static float units2mm(float f) {
        return PLConvert.units2mm(f, 72);
    }

    public static float units2mm(float f, @Nonnegative int n) {
        return f * 25.4f / (float)n;
    }

    public static float cm2units(float f) {
        return PLConvert.cm2units(f, 72);
    }

    public static float cm2units(float f, @Nonnegative int n) {
        return f * (float)n / 2.54f;
    }

    public static float units2cm(float f) {
        return PLConvert.units2cm(f, 72);
    }

    public static float units2cm(float f, @Nonnegative int n) {
        return f * 2.54f / (float)n;
    }

    public static float getWidthForFontSize(float f, float f2) {
        return f * f2 / 1000.0f;
    }
}

