/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.blob.changefeed.implementation.models;

import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonProviders;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.storage.blob.changefeed.implementation.models.SegmentCursor;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.time.OffsetDateTime;
import java.util.Objects;

public class ChangefeedCursor
implements JsonSerializable<ChangefeedCursor> {
    private static final ClientLogger LOGGER = new ClientLogger(ChangefeedCursor.class);
    private int cursorVersion;
    private String urlHost;
    private OffsetDateTime endTime;
    private SegmentCursor currentSegmentCursor;

    public ChangefeedCursor() {
    }

    public ChangefeedCursor(int cursorVersion, String urlHost, OffsetDateTime endTime, SegmentCursor currentSegmentCursor) {
        this.cursorVersion = cursorVersion;
        this.urlHost = urlHost;
        this.endTime = endTime;
        this.currentSegmentCursor = currentSegmentCursor;
    }

    public ChangefeedCursor(String urlHost, OffsetDateTime endTime) {
        this(1, urlHost, endTime, null);
    }

    public ChangefeedCursor toSegmentCursor(String segmentPath, SegmentCursor userSegmentCursor) {
        return new ChangefeedCursor(this.cursorVersion, this.urlHost, this.endTime, new SegmentCursor(segmentPath, userSegmentCursor));
    }

    public ChangefeedCursor toShardCursor(String shardPath) {
        return new ChangefeedCursor(this.cursorVersion, this.urlHost, this.endTime, this.currentSegmentCursor.toShardCursor(shardPath));
    }

    public ChangefeedCursor toEventCursor(String chunkPath, long blockOffset, long eventIndex) {
        return new ChangefeedCursor(this.cursorVersion, this.urlHost, this.endTime, this.currentSegmentCursor.toEventCursor(chunkPath, blockOffset, eventIndex));
    }

    public int getCursorVersion() {
        return this.cursorVersion;
    }

    public String getUrlHost() {
        return this.urlHost;
    }

    public OffsetDateTime getEndTime() {
        return this.endTime;
    }

    public SegmentCursor getCurrentSegmentCursor() {
        return this.currentSegmentCursor;
    }

    public ChangefeedCursor setCursorVersion(int cursorVersion) {
        this.cursorVersion = cursorVersion;
        return this;
    }

    public ChangefeedCursor setUrlHost(String urlHost) {
        this.urlHost = urlHost;
        return this;
    }

    public ChangefeedCursor setEndTime(OffsetDateTime endTime) {
        this.endTime = endTime;
        return this;
    }

    public ChangefeedCursor setCurrentSegmentCursor(SegmentCursor currentSegmentCursor) {
        this.currentSegmentCursor = currentSegmentCursor;
        return this;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public String serialize() {
        try (ByteArrayOutputStream outputStream = new ByteArrayOutputStream();){
            String string;
            block13: {
                JsonWriter jsonWriter = JsonProviders.createWriter((OutputStream)outputStream);
                try {
                    jsonWriter.writeJson((JsonSerializable)this).flush();
                    string = outputStream.toString(StandardCharsets.UTF_8.name());
                    if (jsonWriter == null) break block13;
                }
                catch (Throwable throwable) {
                    if (jsonWriter != null) {
                        try {
                            jsonWriter.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                jsonWriter.close();
            }
            return string;
        }
        catch (IOException e) {
            throw LOGGER.logExceptionAsError((RuntimeException)new UncheckedIOException(e));
        }
    }

    public static ChangefeedCursor deserialize(String cursor, ClientLogger logger) {
        ChangefeedCursor changefeedCursor;
        block8: {
            JsonReader jsonReader = JsonProviders.createReader((String)cursor);
            try {
                changefeedCursor = ChangefeedCursor.fromJson(jsonReader);
                if (jsonReader == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (jsonReader != null) {
                        try {
                            jsonReader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw logger.logExceptionAsError((RuntimeException)new UncheckedIOException(e));
                }
            }
            jsonReader.close();
        }
        return changefeedCursor;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        return jsonWriter.writeStartObject().writeIntField("CursorVersion", this.cursorVersion).writeStringField("UrlHost", this.urlHost).writeStringField("EndTime", this.endTime == null ? null : this.endTime.toString()).writeJsonField("CurrentSegmentCursor", (JsonSerializable)this.currentSegmentCursor).writeEndObject();
    }

    public static ChangefeedCursor fromJson(JsonReader jsonReader) throws IOException {
        return (ChangefeedCursor)jsonReader.readObject(reader -> {
            ChangefeedCursor changefeedCursor = new ChangefeedCursor();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("CursorVersion".equals(fieldName)) {
                    changefeedCursor.cursorVersion = reader.getInt();
                    continue;
                }
                if ("UrlHost".equals(fieldName)) {
                    changefeedCursor.urlHost = reader.getString();
                    continue;
                }
                if ("EndTime".equals(fieldName)) {
                    changefeedCursor.endTime = CoreUtils.parseBestOffsetDateTime((String)reader.getString());
                    continue;
                }
                if ("CurrentSegmentCursor".equals(fieldName)) {
                    changefeedCursor.currentSegmentCursor = SegmentCursor.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return changefeedCursor;
        });
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ChangefeedCursor)) {
            return false;
        }
        ChangefeedCursor cursor = (ChangefeedCursor)o;
        return this.getCursorVersion() == cursor.getCursorVersion() && Objects.equals(this.getUrlHost(), cursor.getUrlHost()) && Objects.equals(this.getEndTime(), cursor.getEndTime()) && Objects.equals(this.getCurrentSegmentCursor(), cursor.getCurrentSegmentCursor());
    }

    public int hashCode() {
        return Objects.hash(this.getCursorVersion(), this.getUrlHost(), this.getEndTime(), this.getCurrentSegmentCursor());
    }
}

