/*
 * Copyright 2020-2025 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.workspacesweb.model;

import java.io.Serializable;
import javax.annotation.Generated;

import com.amazonaws.AmazonWebServiceRequest;

/**
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/CreateBrowserSettings"
 *      target="_top">AWS API Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class CreateBrowserSettingsRequest extends com.amazonaws.AmazonWebServiceRequest implements Serializable, Cloneable {

    /**
     * <p>
     * Additional encryption context of the browser settings.
     * </p>
     */
    private java.util.Map<String, String> additionalEncryptionContext;
    /**
     * <p>
     * A JSON string containing Chrome Enterprise policies that will be applied to all streaming sessions.
     * </p>
     */
    private String browserPolicy;
    /**
     * <p>
     * A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Idempotency
     * ensures that an API request completes only once. With an idempotent request, if the original request completes
     * successfully, subsequent retries with the same client token returns the result from the original successful
     * request.
     * </p>
     * <p>
     * If you do not specify a client token, one is automatically generated by the Amazon Web Services SDK.
     * </p>
     */
    private String clientToken;
    /**
     * <p>
     * The custom managed key of the browser settings.
     * </p>
     */
    private String customerManagedKey;
    /**
     * <p>
     * The tags to add to the browser settings resource. A tag is a key-value pair.
     * </p>
     */
    private java.util.List<Tag> tags;

    /**
     * <p>
     * Additional encryption context of the browser settings.
     * </p>
     * 
     * @return Additional encryption context of the browser settings.
     */

    public java.util.Map<String, String> getAdditionalEncryptionContext() {
        return additionalEncryptionContext;
    }

    /**
     * <p>
     * Additional encryption context of the browser settings.
     * </p>
     * 
     * @param additionalEncryptionContext
     *        Additional encryption context of the browser settings.
     */

    public void setAdditionalEncryptionContext(java.util.Map<String, String> additionalEncryptionContext) {
        this.additionalEncryptionContext = additionalEncryptionContext;
    }

    /**
     * <p>
     * Additional encryption context of the browser settings.
     * </p>
     * 
     * @param additionalEncryptionContext
     *        Additional encryption context of the browser settings.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public CreateBrowserSettingsRequest withAdditionalEncryptionContext(java.util.Map<String, String> additionalEncryptionContext) {
        setAdditionalEncryptionContext(additionalEncryptionContext);
        return this;
    }

    /**
     * Add a single AdditionalEncryptionContext entry
     *
     * @see CreateBrowserSettingsRequest#withAdditionalEncryptionContext
     * @returns a reference to this object so that method calls can be chained together.
     */

    public CreateBrowserSettingsRequest addAdditionalEncryptionContextEntry(String key, String value) {
        if (null == this.additionalEncryptionContext) {
            this.additionalEncryptionContext = new java.util.HashMap<String, String>();
        }
        if (this.additionalEncryptionContext.containsKey(key))
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        this.additionalEncryptionContext.put(key, value);
        return this;
    }

    /**
     * Removes all the entries added into AdditionalEncryptionContext.
     *
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public CreateBrowserSettingsRequest clearAdditionalEncryptionContextEntries() {
        this.additionalEncryptionContext = null;
        return this;
    }

    /**
     * <p>
     * A JSON string containing Chrome Enterprise policies that will be applied to all streaming sessions.
     * </p>
     * 
     * @param browserPolicy
     *        A JSON string containing Chrome Enterprise policies that will be applied to all streaming sessions.
     */

    public void setBrowserPolicy(String browserPolicy) {
        this.browserPolicy = browserPolicy;
    }

    /**
     * <p>
     * A JSON string containing Chrome Enterprise policies that will be applied to all streaming sessions.
     * </p>
     * 
     * @return A JSON string containing Chrome Enterprise policies that will be applied to all streaming sessions.
     */

    public String getBrowserPolicy() {
        return this.browserPolicy;
    }

    /**
     * <p>
     * A JSON string containing Chrome Enterprise policies that will be applied to all streaming sessions.
     * </p>
     * 
     * @param browserPolicy
     *        A JSON string containing Chrome Enterprise policies that will be applied to all streaming sessions.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public CreateBrowserSettingsRequest withBrowserPolicy(String browserPolicy) {
        setBrowserPolicy(browserPolicy);
        return this;
    }

    /**
     * <p>
     * A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Idempotency
     * ensures that an API request completes only once. With an idempotent request, if the original request completes
     * successfully, subsequent retries with the same client token returns the result from the original successful
     * request.
     * </p>
     * <p>
     * If you do not specify a client token, one is automatically generated by the Amazon Web Services SDK.
     * </p>
     * 
     * @param clientToken
     *        A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Idempotency
     *        ensures that an API request completes only once. With an idempotent request, if the original request
     *        completes successfully, subsequent retries with the same client token returns the result from the original
     *        successful request.</p>
     *        <p>
     *        If you do not specify a client token, one is automatically generated by the Amazon Web Services SDK.
     */

    public void setClientToken(String clientToken) {
        this.clientToken = clientToken;
    }

    /**
     * <p>
     * A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Idempotency
     * ensures that an API request completes only once. With an idempotent request, if the original request completes
     * successfully, subsequent retries with the same client token returns the result from the original successful
     * request.
     * </p>
     * <p>
     * If you do not specify a client token, one is automatically generated by the Amazon Web Services SDK.
     * </p>
     * 
     * @return A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.
     *         Idempotency ensures that an API request completes only once. With an idempotent request, if the original
     *         request completes successfully, subsequent retries with the same client token returns the result from the
     *         original successful request.</p>
     *         <p>
     *         If you do not specify a client token, one is automatically generated by the Amazon Web Services SDK.
     */

    public String getClientToken() {
        return this.clientToken;
    }

    /**
     * <p>
     * A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Idempotency
     * ensures that an API request completes only once. With an idempotent request, if the original request completes
     * successfully, subsequent retries with the same client token returns the result from the original successful
     * request.
     * </p>
     * <p>
     * If you do not specify a client token, one is automatically generated by the Amazon Web Services SDK.
     * </p>
     * 
     * @param clientToken
     *        A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Idempotency
     *        ensures that an API request completes only once. With an idempotent request, if the original request
     *        completes successfully, subsequent retries with the same client token returns the result from the original
     *        successful request.</p>
     *        <p>
     *        If you do not specify a client token, one is automatically generated by the Amazon Web Services SDK.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public CreateBrowserSettingsRequest withClientToken(String clientToken) {
        setClientToken(clientToken);
        return this;
    }

    /**
     * <p>
     * The custom managed key of the browser settings.
     * </p>
     * 
     * @param customerManagedKey
     *        The custom managed key of the browser settings.
     */

    public void setCustomerManagedKey(String customerManagedKey) {
        this.customerManagedKey = customerManagedKey;
    }

    /**
     * <p>
     * The custom managed key of the browser settings.
     * </p>
     * 
     * @return The custom managed key of the browser settings.
     */

    public String getCustomerManagedKey() {
        return this.customerManagedKey;
    }

    /**
     * <p>
     * The custom managed key of the browser settings.
     * </p>
     * 
     * @param customerManagedKey
     *        The custom managed key of the browser settings.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public CreateBrowserSettingsRequest withCustomerManagedKey(String customerManagedKey) {
        setCustomerManagedKey(customerManagedKey);
        return this;
    }

    /**
     * <p>
     * The tags to add to the browser settings resource. A tag is a key-value pair.
     * </p>
     * 
     * @return The tags to add to the browser settings resource. A tag is a key-value pair.
     */

    public java.util.List<Tag> getTags() {
        return tags;
    }

    /**
     * <p>
     * The tags to add to the browser settings resource. A tag is a key-value pair.
     * </p>
     * 
     * @param tags
     *        The tags to add to the browser settings resource. A tag is a key-value pair.
     */

    public void setTags(java.util.Collection<Tag> tags) {
        if (tags == null) {
            this.tags = null;
            return;
        }

        this.tags = new java.util.ArrayList<Tag>(tags);
    }

    /**
     * <p>
     * The tags to add to the browser settings resource. A tag is a key-value pair.
     * </p>
     * <p>
     * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
     * {@link #setTags(java.util.Collection)} or {@link #withTags(java.util.Collection)} if you want to override the
     * existing values.
     * </p>
     * 
     * @param tags
     *        The tags to add to the browser settings resource. A tag is a key-value pair.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public CreateBrowserSettingsRequest withTags(Tag... tags) {
        if (this.tags == null) {
            setTags(new java.util.ArrayList<Tag>(tags.length));
        }
        for (Tag ele : tags) {
            this.tags.add(ele);
        }
        return this;
    }

    /**
     * <p>
     * The tags to add to the browser settings resource. A tag is a key-value pair.
     * </p>
     * 
     * @param tags
     *        The tags to add to the browser settings resource. A tag is a key-value pair.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public CreateBrowserSettingsRequest withTags(java.util.Collection<Tag> tags) {
        setTags(tags);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getAdditionalEncryptionContext() != null)
            sb.append("AdditionalEncryptionContext: ").append(getAdditionalEncryptionContext()).append(",");
        if (getBrowserPolicy() != null)
            sb.append("BrowserPolicy: ").append("***Sensitive Data Redacted***").append(",");
        if (getClientToken() != null)
            sb.append("ClientToken: ").append(getClientToken()).append(",");
        if (getCustomerManagedKey() != null)
            sb.append("CustomerManagedKey: ").append(getCustomerManagedKey()).append(",");
        if (getTags() != null)
            sb.append("Tags: ").append("***Sensitive Data Redacted***");
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof CreateBrowserSettingsRequest == false)
            return false;
        CreateBrowserSettingsRequest other = (CreateBrowserSettingsRequest) obj;
        if (other.getAdditionalEncryptionContext() == null ^ this.getAdditionalEncryptionContext() == null)
            return false;
        if (other.getAdditionalEncryptionContext() != null && other.getAdditionalEncryptionContext().equals(this.getAdditionalEncryptionContext()) == false)
            return false;
        if (other.getBrowserPolicy() == null ^ this.getBrowserPolicy() == null)
            return false;
        if (other.getBrowserPolicy() != null && other.getBrowserPolicy().equals(this.getBrowserPolicy()) == false)
            return false;
        if (other.getClientToken() == null ^ this.getClientToken() == null)
            return false;
        if (other.getClientToken() != null && other.getClientToken().equals(this.getClientToken()) == false)
            return false;
        if (other.getCustomerManagedKey() == null ^ this.getCustomerManagedKey() == null)
            return false;
        if (other.getCustomerManagedKey() != null && other.getCustomerManagedKey().equals(this.getCustomerManagedKey()) == false)
            return false;
        if (other.getTags() == null ^ this.getTags() == null)
            return false;
        if (other.getTags() != null && other.getTags().equals(this.getTags()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getAdditionalEncryptionContext() == null) ? 0 : getAdditionalEncryptionContext().hashCode());
        hashCode = prime * hashCode + ((getBrowserPolicy() == null) ? 0 : getBrowserPolicy().hashCode());
        hashCode = prime * hashCode + ((getClientToken() == null) ? 0 : getClientToken().hashCode());
        hashCode = prime * hashCode + ((getCustomerManagedKey() == null) ? 0 : getCustomerManagedKey().hashCode());
        hashCode = prime * hashCode + ((getTags() == null) ? 0 : getTags().hashCode());
        return hashCode;
    }

    @Override
    public CreateBrowserSettingsRequest clone() {
        return (CreateBrowserSettingsRequest) super.clone();
    }

}
