/*
 * Copyright 2019-2024 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.mediaconnect.model.transform;

import java.util.List;
import javax.annotation.Generated;

import com.amazonaws.SdkClientException;
import com.amazonaws.services.mediaconnect.model.*;

import com.amazonaws.protocol.*;
import com.amazonaws.annotation.SdkInternalApi;

/**
 * UpdateFlowOutputRequestMarshaller
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
@SdkInternalApi
public class UpdateFlowOutputRequestMarshaller {

    private static final MarshallingInfo<List> CIDRALLOWLIST_BINDING = MarshallingInfo.builder(MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("cidrAllowList").build();
    private static final MarshallingInfo<String> DESCRIPTION_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("description").build();
    private static final MarshallingInfo<String> DESTINATION_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("destination").build();
    private static final MarshallingInfo<StructuredPojo> ENCRYPTION_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("encryption").build();
    private static final MarshallingInfo<String> FLOWARN_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PATH)
            .marshallLocationName("flowArn").build();
    private static final MarshallingInfo<Integer> MAXLATENCY_BINDING = MarshallingInfo.builder(MarshallingType.INTEGER)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("maxLatency").build();
    private static final MarshallingInfo<List> MEDIASTREAMOUTPUTCONFIGURATIONS_BINDING = MarshallingInfo.builder(MarshallingType.LIST)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("mediaStreamOutputConfigurations").build();
    private static final MarshallingInfo<Integer> MINLATENCY_BINDING = MarshallingInfo.builder(MarshallingType.INTEGER)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("minLatency").build();
    private static final MarshallingInfo<String> OUTPUTARN_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PATH)
            .marshallLocationName("outputArn").build();
    private static final MarshallingInfo<Integer> PORT_BINDING = MarshallingInfo.builder(MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("port").build();
    private static final MarshallingInfo<String> PROTOCOL_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("protocol").build();
    private static final MarshallingInfo<String> REMOTEID_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("remoteId").build();
    private static final MarshallingInfo<Integer> SENDERCONTROLPORT_BINDING = MarshallingInfo.builder(MarshallingType.INTEGER)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("senderControlPort").build();
    private static final MarshallingInfo<String> SENDERIPADDRESS_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("senderIpAddress").build();
    private static final MarshallingInfo<Integer> SMOOTHINGLATENCY_BINDING = MarshallingInfo.builder(MarshallingType.INTEGER)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("smoothingLatency").build();
    private static final MarshallingInfo<String> STREAMID_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("streamId").build();
    private static final MarshallingInfo<StructuredPojo> VPCINTERFACEATTACHMENT_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("vpcInterfaceAttachment").build();
    private static final MarshallingInfo<String> OUTPUTSTATUS_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("outputStatus").build();

    private static final UpdateFlowOutputRequestMarshaller instance = new UpdateFlowOutputRequestMarshaller();

    public static UpdateFlowOutputRequestMarshaller getInstance() {
        return instance;
    }

    /**
     * Marshall the given parameter object.
     */
    public void marshall(UpdateFlowOutputRequest updateFlowOutputRequest, ProtocolMarshaller protocolMarshaller) {

        if (updateFlowOutputRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        try {
            protocolMarshaller.marshall(updateFlowOutputRequest.getCidrAllowList(), CIDRALLOWLIST_BINDING);
            protocolMarshaller.marshall(updateFlowOutputRequest.getDescription(), DESCRIPTION_BINDING);
            protocolMarshaller.marshall(updateFlowOutputRequest.getDestination(), DESTINATION_BINDING);
            protocolMarshaller.marshall(updateFlowOutputRequest.getEncryption(), ENCRYPTION_BINDING);
            protocolMarshaller.marshall(updateFlowOutputRequest.getFlowArn(), FLOWARN_BINDING);
            protocolMarshaller.marshall(updateFlowOutputRequest.getMaxLatency(), MAXLATENCY_BINDING);
            protocolMarshaller.marshall(updateFlowOutputRequest.getMediaStreamOutputConfigurations(), MEDIASTREAMOUTPUTCONFIGURATIONS_BINDING);
            protocolMarshaller.marshall(updateFlowOutputRequest.getMinLatency(), MINLATENCY_BINDING);
            protocolMarshaller.marshall(updateFlowOutputRequest.getOutputArn(), OUTPUTARN_BINDING);
            protocolMarshaller.marshall(updateFlowOutputRequest.getPort(), PORT_BINDING);
            protocolMarshaller.marshall(updateFlowOutputRequest.getProtocol(), PROTOCOL_BINDING);
            protocolMarshaller.marshall(updateFlowOutputRequest.getRemoteId(), REMOTEID_BINDING);
            protocolMarshaller.marshall(updateFlowOutputRequest.getSenderControlPort(), SENDERCONTROLPORT_BINDING);
            protocolMarshaller.marshall(updateFlowOutputRequest.getSenderIpAddress(), SENDERIPADDRESS_BINDING);
            protocolMarshaller.marshall(updateFlowOutputRequest.getSmoothingLatency(), SMOOTHINGLATENCY_BINDING);
            protocolMarshaller.marshall(updateFlowOutputRequest.getStreamId(), STREAMID_BINDING);
            protocolMarshaller.marshall(updateFlowOutputRequest.getVpcInterfaceAttachment(), VPCINTERFACEATTACHMENT_BINDING);
            protocolMarshaller.marshall(updateFlowOutputRequest.getOutputStatus(), OUTPUTSTATUS_BINDING);
        } catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }

}
