/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.connectcampaign.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.connectcampaign.model.DialRequest;
import java.util.Date;
import java.util.Map;

@SdkInternalApi
public class DialRequestMarshaller {
    private static final MarshallingInfo<String> CLIENTTOKEN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("clientToken").build();
    private static final MarshallingInfo<String> PHONENUMBER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("phoneNumber").build();
    private static final MarshallingInfo<Date> EXPIRATIONTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("expirationTime").timestampFormat("iso8601").build();
    private static final MarshallingInfo<Map> ATTRIBUTES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("attributes").build();
    private static final DialRequestMarshaller instance = new DialRequestMarshaller();

    public static DialRequestMarshaller getInstance() {
        return instance;
    }

    public void marshall(DialRequest dialRequest, ProtocolMarshaller protocolMarshaller) {
        if (dialRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)dialRequest.getClientToken(), CLIENTTOKEN_BINDING);
            protocolMarshaller.marshall((Object)dialRequest.getPhoneNumber(), PHONENUMBER_BINDING);
            protocolMarshaller.marshall((Object)dialRequest.getExpirationTime(), EXPIRATIONTIME_BINDING);
            protocolMarshaller.marshall(dialRequest.getAttributes(), ATTRIBUTES_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

